/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.history;

import java.util.List;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.editor.commons.client.file.RestorePopup;
import org.uberfire.ext.editor.commons.client.file.RestoreUtil;
import org.uberfire.ext.editor.commons.client.history.SaveButton;
import org.uberfire.ext.editor.commons.client.history.VersionMenuDropDownButton;
import org.uberfire.ext.editor.commons.client.history.VersionMenuItem;
import org.uberfire.ext.editor.commons.client.history.event.VersionSelectedEvent;
import org.uberfire.ext.editor.commons.version.VersionService;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuItem;

public class VersionRecordManager {
    private VersionMenuDropDownButton versionMenuDropDownButton;
    private Event<VersionSelectedEvent> versionSelectedEvent;
    private RestorePopup restorePopup;
    private RestoreUtil restoreUtil;
    private Caller<VersionService> versionService;
    private Callback<VersionRecord> selectionCallback;
    private List<VersionRecord> versions;
    private ObservablePath pathToLatest;
    private String version;
    private SaveButton saveButton;

    @Inject
    public VersionRecordManager(VersionMenuDropDownButton versionMenuDropDownButton, RestorePopup restorePopup, RestoreUtil restoreUtil, Event<VersionSelectedEvent> versionSelectedEvent, Caller<VersionService> versionService) {
        this.restorePopup = restorePopup;
        this.versionMenuDropDownButton = versionMenuDropDownButton;
        this.versionSelectedEvent = versionSelectedEvent;
        versionMenuDropDownButton.addSelectionCallback(new Callback<VersionRecord>(){

            public void callback(VersionRecord versionRecord) {
                VersionRecordManager.this.fireVersionSelected(versionRecord);
            }
        });
        this.restoreUtil = restoreUtil;
        this.versionService = versionService;
    }

    private void fireVersionSelected(VersionRecord versionRecord) {
        this.versionSelectedEvent.fire((Object)new VersionSelectedEvent((Path)this.getPathToLatest(), versionRecord));
    }

    public void init(String version, ObservablePath path, Callback<VersionRecord> selectionCallback) {
        this.clear();
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        this.selectionCallback = (Callback)PortablePreconditions.checkNotNull((String)"selectionCallback", selectionCallback);
        this.version = version;
        if (version == null) {
            this.setPathToLatest(path);
        }
        this.loadVersions(path);
    }

    public MenuItem buildMenu() {
        return new VersionMenuItem(this.versionMenuDropDownButton);
    }

    public void setVersions(List<VersionRecord> versions) {
        if (this.version == null) {
            this.version = versions.get(versions.size() - 1).id();
        }
        this.setVersions(versions, this.version);
    }

    private void setVersions(List<VersionRecord> versions, String version) {
        PortablePreconditions.checkNotNull((String)"versions", versions);
        this.resolveVersions(versions);
        this.versionMenuDropDownButton.setItems(versions);
        this.versionMenuDropDownButton.setVersion(version);
    }

    public void setShowMoreCommand(Command showMore) {
        this.versionMenuDropDownButton.setShowMoreCommand(showMore);
    }

    private void resolveVersions(List<VersionRecord> versions) {
        if (this.versions == null || versions.size() > this.versions.size()) {
            this.versions = versions;
        }
    }

    public MenuItem newSaveMenuItem(Command command) {
        this.saveButton = new SaveButton(command);
        return this.saveButton;
    }

    public boolean isLatest(VersionRecord versionRecord) {
        return this.versions.get(this.versions.size() - 1).id().equals(versionRecord.id());
    }

    private void setPathToLatest(ObservablePath pathToLatest) {
        this.pathToLatest = (ObservablePath)PortablePreconditions.checkNotNull((String)"pathToLatest", (Object)pathToLatest);
    }

    public ObservablePath getPathToLatest() {
        return this.pathToLatest;
    }

    public void onVersionSelectedEvent(@Observes VersionSelectedEvent event) {
        if (event.getPathToFile().equals(this.getPathToLatest()) && this.selectionCallback != null) {
            this.selectionCallback.callback((Object)event.getVersionRecord());
        }
    }

    public void setVersion(String version) {
        this.version = (String)PortablePreconditions.checkNotNull((String)"version", (Object)version);
        this.versionMenuDropDownButton.setVersion(version);
        if (this.saveButton != null) {
            if (this.isCurrentLatest()) {
                this.saveButton.setTextToSave();
            } else if (this.versions != null) {
                this.saveButton.setTextToRestore();
            }
        }
    }

    public String getVersion() {
        return this.version;
    }

    public ObservablePath getCurrentPath() {
        if (this.isCurrentLatest()) {
            return this.getPathToLatest();
        }
        return this.restoreUtil.createObservablePath((Path)this.getPathToLatest(), this.getCurrentVersionRecordUri());
    }

    public boolean isCurrentLatest() {
        return this.versions == null || this.getLatestVersionRecord().id().equals(this.version);
    }

    private VersionRecord getLatestVersionRecord() {
        return this.versions.get(this.versions.size() - 1);
    }

    private String getCurrentVersionRecordUri() {
        VersionRecord record = this.getCurrentVersionRecord();
        if (record == null) {
            return this.getPathToLatest().toURI();
        }
        return record.uri();
    }

    private VersionRecord getCurrentVersionRecord() {
        for (VersionRecord versionRecord : this.versions) {
            if (!versionRecord.id().equals(this.version)) continue;
            return versionRecord;
        }
        return null;
    }

    public void restoreToCurrentVersion() {
        this.restorePopup.show(this.getCurrentPath(), this.getCurrentVersionRecordUri());
    }

    private void loadVersions(ObservablePath path) {
        this.loadVersions((Path)path, new Callback<List<VersionRecord>>(){

            public void callback(List<VersionRecord> records) {
                VersionRecordManager.this.doesTheVersionExist(records);
            }
        });
    }

    private void doesTheVersionExist(List<VersionRecord> records) {
        boolean found = false;
        for (VersionRecord versionRecord : records) {
            if (!versionRecord.id().equals(this.version)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Unknown version");
        }
    }

    public void reloadVersions(Path path) {
        this.loadVersions(path, new Callback<List<VersionRecord>>(){

            public void callback(List<VersionRecord> records) {
                VersionRecordManager.this.setVersion(records.get(records.size() - 1).id());
            }
        });
    }

    private void loadVersions(final Path path, final Callback<List<VersionRecord>> callback) {
        ((VersionService)this.versionService.call((RemoteCallback)new RemoteCallback<List<VersionRecord>>(){

            public void callback(List<VersionRecord> records) {
                String uri = path.toURI();
                if (!path.equals(VersionRecordManager.this.pathToLatest)) {
                    VersionRecordManager.this.setPathToLatest(VersionRecordManager.this.restoreUtil.createObservablePath(path, uri));
                }
                VersionRecordManager.this.setVersions(records);
                callback.callback(records);
            }
        })).getVersions(path);
    }

    public void clear() {
        this.selectionCallback = null;
        this.versions = null;
        this.pathToLatest = null;
        this.version = null;
    }
}

