/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file;

import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.editor.commons.client.file.CommandWithFileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.FileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.resources.CommonImages;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;

public class RenamePopup
extends FormStylePopup {
    private final TextBox nameTextBox = new TextBox();
    private final TextBox checkInCommentTextBox = new TextBox();

    public RenamePopup(Path path, CommandWithFileNameAndCommitMessage command) {
        this(path, new Validator(){

            @Override
            public void validate(String value, ValidatorCallback callback) {
                callback.onSuccess();
            }
        }, command);
    }

    public RenamePopup(final Path path, final Validator validator, final CommandWithFileNameAndCommitMessage command) {
        super(CommonImages.INSTANCE.edit(), CommonConstants.INSTANCE.RenamePopupTitle());
        PortablePreconditions.checkNotNull((String)"validator", (Object)validator);
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        PortablePreconditions.checkNotNull((String)"command", (Object)command);
        this.getElement().getStyle().setZIndex(Integer.MAX_VALUE);
        this.nameTextBox.setTitle(CommonConstants.INSTANCE.NewName());
        this.nameTextBox.setWidth("200px");
        this.addAttribute(CommonConstants.INSTANCE.NewNameColon(), (IsWidget)this.nameTextBox);
        this.checkInCommentTextBox.setTitle(CommonConstants.INSTANCE.CheckInComment());
        this.checkInCommentTextBox.setWidth("200px");
        this.addAttribute(CommonConstants.INSTANCE.CheckInCommentColon(), (IsWidget)this.checkInCommentTextBox);
        GenericModalFooter footer = new GenericModalFooter();
        footer.addButton(CommonConstants.INSTANCE.RenamePopupRenameItem(), new Command(){

            public void execute() {
                final String baseFileName = RenamePopup.this.nameTextBox.getText();
                String originalFileName = path.getFileName();
                String extension = originalFileName.lastIndexOf(".") > 0 ? originalFileName.substring(originalFileName.lastIndexOf(".")) : "";
                String fileName = baseFileName + extension;
                validator.validate(fileName, new ValidatorCallback(){

                    @Override
                    public void onSuccess() {
                        RenamePopup.this.hide();
                        command.execute(new FileNameAndCommitMessage(baseFileName, RenamePopup.this.checkInCommentTextBox.getText()));
                    }

                    @Override
                    public void onFailure() {
                        Window.alert((String)CommonConstants.INSTANCE.InvalidFileName0(baseFileName));
                    }
                });
            }
        }, IconType.SAVE, ButtonType.PRIMARY);
        footer.addButton(CommonConstants.INSTANCE.Cancel(), new Command(){

            public void execute() {
                RenamePopup.this.hide();
            }
        }, ButtonType.DEFAULT);
        this.add((Widget)footer);
    }
}

