/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.file.CommandWithFileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.CopyPopup;
import org.uberfire.ext.editor.commons.client.file.CopyPopupView;
import org.uberfire.ext.editor.commons.client.file.FileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;

@RunWith(value=MockitoJUnitRunner.class)
public class CopyPopupTest {
    private static final String NAME_TEXT = "copy name";
    private static final String COMMENT_TEXT = "hello world";
    private static final String PATH = "dir/file.ext";
    private Validator successValidator;
    private Validator failureValidator;
    @Mock
    private CopyPopupView view;
    @Mock
    private Path path;
    @Mock
    private CommandWithFileNameAndCommitMessage command;
    @Captor
    private ArgumentCaptor<FileNameAndCommitMessage> msgCaptor;

    @Before
    public void setUp() {
        Mockito.when((Object)this.path.getFileName()).thenReturn((Object)PATH);
        Mockito.when((Object)this.view.getCheckInComment()).thenReturn((Object)COMMENT_TEXT);
        Mockito.when((Object)this.view.getNewName()).thenReturn((Object)NAME_TEXT);
        this.successValidator = (Validator)Mockito.spy((Object)new Validator(){

            public void validate(String value, ValidatorCallback callback) {
                callback.onSuccess();
            }
        });
        this.failureValidator = (Validator)Mockito.spy((Object)new Validator(){

            public void validate(String value, ValidatorCallback callback) {
                callback.onFailure();
            }
        });
    }

    @Test
    public void testSuccessfulValidation() {
        CopyPopup popup = new CopyPopup(this.path, this.successValidator, this.command, this.view);
        popup.onCopy();
        ((Validator)Mockito.verify((Object)this.successValidator)).validate((String)Mockito.any(String.class), (ValidatorCallback)Mockito.any(ValidatorCallback.class));
        ((CommandWithFileNameAndCommitMessage)Mockito.verify((Object)this.command)).execute(this.msgCaptor.capture());
        Assert.assertThat((Object)((FileNameAndCommitMessage)this.msgCaptor.getValue()).getNewFileName(), (Matcher)CoreMatchers.equalTo((Object)NAME_TEXT));
        Assert.assertThat((Object)((FileNameAndCommitMessage)this.msgCaptor.getValue()).getCommitMessage(), (Matcher)CoreMatchers.equalTo((Object)COMMENT_TEXT));
    }

    @Test
    public void testFailedValidation() {
        CopyPopup popup = new CopyPopup(this.path, this.failureValidator, this.command, this.view);
        popup.onCopy();
        ((Validator)Mockito.verify((Object)this.failureValidator)).validate(Mockito.anyString(), (ValidatorCallback)Mockito.any(ValidatorCallback.class));
        ((CommandWithFileNameAndCommitMessage)Mockito.verify((Object)this.command, (VerificationMode)Mockito.never())).execute(Mockito.any(FileNameAndCommitMessage.class));
        ((CopyPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide();
        ((CopyPopupView)Mockito.verify((Object)this.view)).handleInvalidFileName();
    }

    @Test
    public void testPopupCanceled() {
        CopyPopup popup = new CopyPopup(this.path, this.successValidator, this.command, this.view);
        popup.onCancel();
        ((Validator)Mockito.verify((Object)this.successValidator, (VerificationMode)Mockito.never())).validate(Mockito.anyString(), (ValidatorCallback)Mockito.any(ValidatorCallback.class));
        ((CommandWithFileNameAndCommitMessage)Mockito.verify((Object)this.command, (VerificationMode)Mockito.never())).execute(Mockito.any(FileNameAndCommitMessage.class));
        ((CopyPopupView)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testDefaultValidator() {
        Mockito.when((Object)this.view.getNewName()).thenReturn(null);
        Mockito.when((Object)this.view.getCheckInComment()).thenReturn(null);
        CopyPopup popup = new CopyPopup(this.path, this.command, this.view);
        popup.onCopy();
        ((CommandWithFileNameAndCommitMessage)Mockito.verify((Object)this.command)).execute(this.msgCaptor.capture());
        Assert.assertThat((Object)((FileNameAndCommitMessage)this.msgCaptor.getValue()).getNewFileName(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)((FileNameAndCommitMessage)this.msgCaptor.getValue()).getCommitMessage(), (Matcher)CoreMatchers.nullValue());
    }
}

