/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.history;

import java.util.ArrayList;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.editor.commons.client.history.Helper;
import org.uberfire.ext.editor.commons.client.history.VersionMenuDropDownButton;
import org.uberfire.ext.editor.commons.client.history.VersionMenuDropDownButtonView;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.mvp.Command;

public class VersionMenuDropDownButtonTest {
    private VersionMenuDropDownButtonView view;
    private VersionMenuDropDownButton button;

    @Before
    public void setUp() throws Exception {
        this.view = (VersionMenuDropDownButtonView)Mockito.mock(VersionMenuDropDownButtonView.class);
        this.button = new VersionMenuDropDownButton(this.view);
    }

    @Test
    public void testPresenterSet() throws Exception {
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).setPresenter((VersionMenuDropDownButtonView.Presenter)this.button);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoVersion() throws Exception {
        this.button.setItems(new ArrayList());
        this.button.onMenuOpening();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoVersionRecords() throws Exception {
        this.button.setVersion("111");
        this.button.onMenuOpening();
    }

    @Test
    public void testVersionChange() throws Exception {
        ArrayList<VersionRecord> versionRecords = new ArrayList<VersionRecord>();
        versionRecords.add(Helper.getVersionRecord("1111"));
        versionRecords.add(Helper.getVersionRecord("2222"));
        versionRecords.add(Helper.getVersionRecord("3333"));
        this.button.setItems(versionRecords);
        this.button.setVersion("3333");
        this.button.onMenuOpening();
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).addLabel((VersionRecord)Mockito.eq(versionRecords.get(2)), Mockito.eq((boolean)true), Mockito.eq((int)3));
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).addLabel((VersionRecord)Mockito.eq(versionRecords.get(1)), Mockito.eq((boolean)false), Mockito.eq((int)2));
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).addLabel((VersionRecord)Mockito.eq(versionRecords.get(0)), Mockito.eq((boolean)false), Mockito.eq((int)1));
        this.button.setVersion("2222");
        this.button.onMenuOpening();
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).addLabel((VersionRecord)Mockito.eq(versionRecords.get(2)), Mockito.eq((boolean)false), Mockito.eq((int)3));
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).addLabel((VersionRecord)Mockito.eq(versionRecords.get(1)), Mockito.eq((boolean)true), Mockito.eq((int)2));
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addLabel((VersionRecord)Mockito.eq(versionRecords.get(0)), Mockito.eq((boolean)false), Mockito.eq((int)1));
    }

    @Test
    public void testItemsCanNotBeSetToLessThanBefore() throws Exception {
        ArrayList<VersionRecord> versions = new ArrayList<VersionRecord>();
        versions.add(Helper.getVersionRecord("1111"));
        versions.add(Helper.getVersionRecord("2222"));
        this.button.setItems(versions);
        this.button.setVersion("1111");
        this.button.onMenuOpening();
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addLabel((VersionRecord)Mockito.any(VersionRecord.class), Mockito.anyBoolean(), Mockito.anyInt());
        ArrayList<VersionRecord> versions2 = new ArrayList<VersionRecord>();
        versions2.add(Helper.getVersionRecord("1111"));
        this.button.setItems(versions2);
        this.button.onMenuOpening();
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)4))).addLabel((VersionRecord)Mockito.any(VersionRecord.class), Mockito.anyBoolean(), Mockito.anyInt());
    }

    @Test
    public void testNewVersionAdded() throws Exception {
        ArrayList<VersionRecord> versionRecords = new ArrayList<VersionRecord>();
        versionRecords.add(Helper.getVersionRecord("1111"));
        versionRecords.add(Helper.getVersionRecord("2222"));
        versionRecords.add(Helper.getVersionRecord("3333"));
        this.button.setItems(versionRecords);
        this.button.setVersion("3333");
        this.button.onMenuOpening();
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).addLabel((VersionRecord)Mockito.eq(versionRecords.get(2)), Mockito.eq((boolean)true), Mockito.eq((int)3));
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).addLabel((VersionRecord)Mockito.eq(versionRecords.get(1)), Mockito.eq((boolean)false), Mockito.eq((int)2));
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).addLabel((VersionRecord)Mockito.eq(versionRecords.get(0)), Mockito.eq((boolean)false), Mockito.eq((int)1));
        ArrayList<VersionRecord> versionRecords2 = new ArrayList<VersionRecord>();
        versionRecords2.add(Helper.getVersionRecord("1111"));
        versionRecords2.add(Helper.getVersionRecord("2222"));
        versionRecords2.add(Helper.getVersionRecord("3333"));
        versionRecords2.add(Helper.getVersionRecord("4444"));
        this.button.setItems(versionRecords2);
        this.button.setVersion("4444");
        this.button.onMenuOpening();
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).addLabel((VersionRecord)Mockito.eq(versionRecords2.get(3)), Mockito.eq((boolean)true), Mockito.eq((int)4));
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).addLabel((VersionRecord)Mockito.eq(versionRecords2.get(2)), Mockito.eq((boolean)false), Mockito.eq((int)3));
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).addLabel((VersionRecord)Mockito.eq(versionRecords2.get(1)), Mockito.eq((boolean)false), Mockito.eq((int)2));
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).addLabel((VersionRecord)Mockito.eq(versionRecords2.get(0)), Mockito.eq((boolean)false), Mockito.eq((int)1));
    }

    @Test
    public void testShowMoreCount() {
        ArrayList<VersionRecord> versionRecords = new ArrayList<VersionRecord>();
        versionRecords.add(Helper.getVersionRecord("1111"));
        versionRecords.add(Helper.getVersionRecord("2222"));
        versionRecords.add(Helper.getVersionRecord("3333"));
        versionRecords.add(Helper.getVersionRecord("4444"));
        versionRecords.add(Helper.getVersionRecord("5555"));
        versionRecords.add(Helper.getVersionRecord("6666"));
        versionRecords.add(Helper.getVersionRecord("7777"));
        versionRecords.add(Helper.getVersionRecord("8888"));
        versionRecords.add(Helper.getVersionRecord("9999"));
        this.button.setItems(versionRecords);
        this.button.setVersion("3333");
        this.button.onMenuOpening();
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).addLabel((VersionRecord)Mockito.eq(versionRecords.get(8)), Mockito.eq((boolean)false), Mockito.eq((int)9));
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).addLabel((VersionRecord)Mockito.eq(versionRecords.get(7)), Mockito.eq((boolean)false), Mockito.eq((int)8));
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).addLabel((VersionRecord)Mockito.eq(versionRecords.get(6)), Mockito.eq((boolean)false), Mockito.eq((int)7));
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).addLabel((VersionRecord)Mockito.eq(versionRecords.get(5)), Mockito.eq((boolean)false), Mockito.eq((int)6));
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).addLabel((VersionRecord)Mockito.eq(versionRecords.get(4)), Mockito.eq((boolean)false), Mockito.eq((int)5));
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).addLabel((VersionRecord)Mockito.eq(versionRecords.get(3)), Mockito.eq((boolean)false), Mockito.eq((int)4));
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).addLabel((VersionRecord)Mockito.eq(versionRecords.get(2)), Mockito.eq((boolean)true), Mockito.eq((int)3));
        ((VersionMenuDropDownButtonView)Mockito.verify((Object)this.view)).addViewAllLabel(Mockito.eq((int)2), (Command)Mockito.any(Command.class));
    }
}

