/*
 * Copyright 2015 JBoss, by Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.uberfire.ext.editor.commons.client.history;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.mvp.Command;

public class ViewAllLabel
        extends Composite {

    private Command showAllCommand;

    interface Binder
            extends
            UiBinder<Widget, ViewAllLabel> {

    }

    private static Binder uiBinder = GWT.create(Binder.class);

    @UiField Label amount;
    @UiField Label link;

    public ViewAllLabel(Integer amount, Command showAllCommand) {
        this.showAllCommand = showAllCommand;

        initWidget(uiBinder.createAndBindUi(this));

        this.amount.setText(amount.toString());

    }

    @UiHandler("link")
    public void handleClick(ClickEvent event) {
        showAllCommand.execute();
    }
}
