/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file;

import java.lang.annotation.Annotation;
import org.jboss.errai.ioc.client.container.IOC;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.editor.commons.client.file.CommandWithFileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.FileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.RenamePopupView;
import org.uberfire.ext.editor.commons.client.validation.ValidationErrorReason;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;

public class RenamePopup
implements RenamePopupView.Presenter {
    private final RenamePopupView view;
    private final Path path;
    private final Validator validator;
    private final CommandWithFileNameAndCommitMessage command;

    public RenamePopup(Path path, CommandWithFileNameAndCommitMessage command) {
        this(path, command, RenamePopup.getDefaultView());
    }

    public RenamePopup(Path path, CommandWithFileNameAndCommitMessage command, RenamePopupView view) {
        this(path, new Validator(){

            @Override
            public void validate(String value, ValidatorCallback callback) {
                callback.onSuccess();
            }
        }, command, view);
    }

    public RenamePopup(Path path, Validator validator, CommandWithFileNameAndCommitMessage command) {
        this(path, validator, command, RenamePopup.getDefaultView());
    }

    public RenamePopup(Path path, Validator validator, CommandWithFileNameAndCommitMessage command, RenamePopupView view) {
        this.validator = (Validator)PortablePreconditions.checkNotNull((String)"validator", (Object)validator);
        this.path = (Path)PortablePreconditions.checkNotNull((String)"path", (Object)path);
        this.command = (CommandWithFileNameAndCommitMessage)PortablePreconditions.checkNotNull((String)"command", (Object)command);
        this.view = (RenamePopupView)PortablePreconditions.checkNotNull((String)"view", (Object)view);
        this.view.init(this);
    }

    public void show() {
        this.view.show();
    }

    private void hide() {
        this.view.hide();
    }

    @Override
    public void onCancel() {
        this.hide();
    }

    @Override
    public void onRename() {
        final String baseFileName = this.view.getName();
        String originalFileName = this.path.getFileName();
        String extension = originalFileName.lastIndexOf(".") > 0 ? originalFileName.substring(originalFileName.lastIndexOf(".")) : "";
        String fileName = baseFileName + extension;
        this.validator.validate(fileName, new ValidatorWithReasonCallback(){

            @Override
            public void onFailure(String reason) {
                if (ValidationErrorReason.DUPLICATED_NAME.name().equals(reason)) {
                    RenamePopup.this.view.handleDuplicatedFileName();
                } else {
                    RenamePopup.this.view.handleInvalidFileName();
                }
            }

            @Override
            public void onSuccess() {
                RenamePopup.this.command.execute(new FileNameAndCommitMessage(baseFileName, RenamePopup.this.view.getCheckInComment()));
            }

            @Override
            public void onFailure() {
                RenamePopup.this.view.handleInvalidFileName();
            }
        });
    }

    public static RenamePopupView getDefaultView() {
        return (RenamePopupView)IOC.getBeanManager().lookupBean(RenamePopupView.class, new Annotation[0]).getInstance();
    }
}

