/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.uberfire.ext.editor.commons.client.file.RenamePopupView;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.widgets.common.client.common.FormStyleItem;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;

@Dependent
public class RenamePopupViewImpl
extends FormStylePopup
implements RenamePopupView {
    private final TextBox nameTextBox = new TextBox();
    private final TextBox checkInCommentTextBox = new TextBox();
    private final HelpBlock nameHelpInline = new HelpBlock();
    private final HelpBlock checkInCommentHelpInline = new HelpBlock();
    FormStyleItem nameFormStyleItem;
    FormStyleItem checkInCommentFormStyleItem;
    private RenamePopupView.Presenter presenter;

    public RenamePopupViewImpl() {
        super(CommonConstants.INSTANCE.RenamePopupTitle());
        this.getElement().getStyle().setZIndex(Integer.MAX_VALUE);
        this.nameTextBox.setTitle(CommonConstants.INSTANCE.NewName());
        this.nameFormStyleItem = this.addAttribute(CommonConstants.INSTANCE.NewNameColon(), (IsWidget)this.nameTextBox);
        this.nameFormStyleItem.getGroup().add((Widget)this.nameHelpInline);
        this.checkInCommentTextBox.setTitle(CommonConstants.INSTANCE.CheckInComment());
        this.checkInCommentFormStyleItem = this.addAttribute(CommonConstants.INSTANCE.CheckInCommentColon(), (IsWidget)this.checkInCommentTextBox);
        this.checkInCommentFormStyleItem.getGroup().add((Widget)this.checkInCommentHelpInline);
        this.hide();
        GenericModalFooter footer = new GenericModalFooter();
        footer.addButton(CommonConstants.INSTANCE.RenamePopupRenameItem(), new Command(){

            public void execute() {
                RenamePopupViewImpl.this.presenter.onRename();
            }
        }, IconType.SAVE, ButtonType.PRIMARY);
        footer.addButton(CommonConstants.INSTANCE.Cancel(), new Command(){

            public void execute() {
                RenamePopupViewImpl.this.presenter.onCancel();
            }
        }, ButtonType.DEFAULT);
        this.add((Widget)footer);
    }

    public void init(RenamePopupView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public String getName() {
        return this.nameTextBox.getText();
    }

    @Override
    public String getCheckInComment() {
        return this.checkInCommentTextBox.getText();
    }

    @Override
    public void handleInvalidFileName() {
        this.handleFileNameValidationError(CommonConstants.INSTANCE.InvalidFileName0(this.getName()));
    }

    @Override
    public void handleDuplicatedFileName() {
        this.handleFileNameValidationError(CommonConstants.INSTANCE.ExceptionFileAlreadyExists0(this.getName()));
    }

    private void handleFileNameValidationError(String message) {
        this.nameFormStyleItem.getFormGroup().setValidationState(ValidationState.ERROR);
        this.nameHelpInline.setText(message);
    }
}

