/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.New;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.editor.commons.client.validation.DefaultFileNameValidator;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.service.support.SupportsCopy;
import org.uberfire.ext.editor.commons.service.support.SupportsDelete;
import org.uberfire.ext.editor.commons.service.support.SupportsRename;
import org.uberfire.ext.editor.commons.version.events.RestoreEvent;
import org.uberfire.ext.widgets.common.client.common.ConcurrentChangePopup;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

public abstract class BaseEditor {
    protected boolean isReadOnly;
    protected BaseEditorView baseView;
    protected ObservablePath.OnConcurrentUpdateEvent concurrentUpdateSessionInfo = null;
    protected Menus menus;
    @Inject
    private PlaceManager placeManager;
    @Inject
    protected Event<ChangeTitleWidgetEvent> changeTitleNotification;
    @Inject
    protected Event<NotificationEvent> notification;
    @Inject
    protected VersionRecordManager versionRecordManager;
    @Inject
    @New
    protected BasicFileMenuBuilder menuBuilder;
    @Inject
    protected DefaultFileNameValidator fileNameValidator;
    protected Set<MenuItems> menuItems = new HashSet<MenuItems>();
    protected PlaceRequest place;
    protected ClientResourceType type;
    protected Integer originalHash;
    private boolean displayShowMoreVersions;

    protected BaseEditor() {
    }

    protected BaseEditor(BaseEditorView baseView) {
        this.baseView = baseView;
    }

    protected void init(ObservablePath path, PlaceRequest place, ClientResourceType type, MenuItems ... menuItems) {
        this.init(path, place, type, true, false, menuItems);
    }

    protected void init(ObservablePath path, PlaceRequest place, ClientResourceType type, boolean addFileChangeListeners, boolean displayShowMoreVersions, MenuItems ... menuItems) {
        this.place = place;
        this.type = type;
        this.menuItems.addAll(Arrays.asList(menuItems));
        this.displayShowMoreVersions = displayShowMoreVersions;
        this.baseView.showLoading();
        this.isReadOnly = this.place.getParameter("readOnly", null) != null;
        this.versionRecordManager.init(this.place.getParameter("version", null), path, new Callback<VersionRecord>(){

            public void callback(VersionRecord versionRecord) {
                BaseEditor.this.selectVersion(versionRecord);
            }
        });
        if (displayShowMoreVersions) {
            this.versionRecordManager.setShowMoreCommand(new Command(){

                public void execute() {
                    BaseEditor.this.showVersions();
                }
            });
        }
        if (addFileChangeListeners) {
            this.addFileChangeListeners(path);
        }
        this.makeMenuBar();
        this.buildMenuBar();
        this.loadContent();
        this.concurrentUpdateSessionInfo = null;
    }

    private void buildMenuBar() {
        if (this.menuBuilder != null) {
            this.menus = this.menuBuilder.build();
        }
    }

    protected void showVersions() {
    }

    protected void makeMenuBar() {
        if (this.menuItems.contains((Object)MenuItems.SAVE)) {
            this.menuBuilder.addSave(new Command(){

                public void execute() {
                    BaseEditor.this.onSave();
                }
            });
        }
        if (this.menuItems.contains((Object)MenuItems.COPY)) {
            this.menuBuilder.addCopy((Path)this.versionRecordManager.getCurrentPath(), this.getCopyValidator(), this.getCopyServiceCaller());
        }
        if (this.menuItems.contains((Object)MenuItems.RENAME)) {
            this.menuBuilder.addRename((Path)this.versionRecordManager.getPathToLatest(), this.getRenameValidator(), this.getRenameServiceCaller());
        }
        if (this.menuItems.contains((Object)MenuItems.DELETE)) {
            this.menuBuilder.addDelete((Path)this.versionRecordManager.getCurrentPath(), this.getDeleteServiceCaller());
        }
        if (this.menuItems.contains((Object)MenuItems.VALIDATE)) {
            this.menuBuilder.addValidate(this.onValidate());
        }
        if (this.menuItems.contains((Object)MenuItems.HISTORY)) {
            this.menuBuilder.addNewTopLevelMenu(this.versionRecordManager.buildMenu());
        }
    }

    public Validator getRenameValidator() {
        return this.fileNameValidator;
    }

    public Validator getCopyValidator() {
        return this.fileNameValidator;
    }

    private void selectVersion(VersionRecord versionRecord) {
        this.baseView.showBusyIndicator(CommonConstants.INSTANCE.Loading());
        this.isReadOnly = !this.versionRecordManager.isLatest(versionRecord);
        this.versionRecordManager.setVersion(versionRecord.id());
        this.loadContent();
    }

    public void setOriginalHash(Integer originalHash) {
        this.originalHash = originalHash;
    }

    private void addFileChangeListeners(ObservablePath path) {
        path.onRename(new Command(){

            public void execute() {
                BaseEditor.this.onRename();
            }
        });
        path.onDelete(new Command(){

            public void execute() {
                BaseEditor.this.onDelete();
            }
        });
        path.onConcurrentUpdate((ParameterizedCommand)new ParameterizedCommand<ObservablePath.OnConcurrentUpdateEvent>(){

            public void execute(ObservablePath.OnConcurrentUpdateEvent eventInfo) {
                BaseEditor.this.concurrentUpdateSessionInfo = eventInfo;
            }
        });
        path.onConcurrentRename((ParameterizedCommand)new ParameterizedCommand<ObservablePath.OnConcurrentRenameEvent>(){

            public void execute(ObservablePath.OnConcurrentRenameEvent info) {
                ConcurrentChangePopup.newConcurrentRename((Path)info.getSource(), (Path)info.getTarget(), (User)info.getIdentity(), (Command)new Command(){

                    public void execute() {
                        BaseEditor.this.disableMenus();
                    }
                }, (Command)new Command(){

                    public void execute() {
                        BaseEditor.this.reload();
                    }
                }).show();
            }
        });
        path.onConcurrentDelete((ParameterizedCommand)new ParameterizedCommand<ObservablePath.OnConcurrentDelete>(){

            public void execute(ObservablePath.OnConcurrentDelete info) {
                ConcurrentChangePopup.newConcurrentDelete((Path)info.getPath(), (User)info.getIdentity(), (Command)new Command(){

                    public void execute() {
                        BaseEditor.this.disableMenus();
                    }
                }, (Command)new Command(){

                    public void execute() {
                        BaseEditor.this.placeManager.closePlace(BaseEditor.this.place);
                    }
                }).show();
            }
        });
    }

    private void onDelete() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                BaseEditor.this.placeManager.forceClosePlace(BaseEditor.this.place);
            }
        });
    }

    protected void onRename() {
        this.refreshTitle();
        this.baseView.showBusyIndicator(CommonConstants.INSTANCE.Loading());
        this.loadContent();
        this.changeTitleNotification.fire((Object)new ChangeTitleWidgetEvent(this.place, this.getTitleText(), this.getTitle()));
    }

    protected IsWidget getTitle() {
        this.refreshTitle();
        return this.baseView.getTitleWidget();
    }

    public String getTitleText() {
        return this.versionRecordManager.getCurrentPath().getFileName() + " - " + this.type.getDescription();
    }

    private void refreshTitle() {
        this.baseView.refreshTitle(this.getTitleText());
    }

    protected void onSave() {
        if (this.isReadOnly && this.versionRecordManager.isCurrentLatest()) {
            this.baseView.alertReadOnly();
            return;
        }
        if (this.isReadOnly && !this.versionRecordManager.isCurrentLatest()) {
            this.versionRecordManager.restoreToCurrentVersion();
            return;
        }
        if (this.concurrentUpdateSessionInfo != null) {
            this.showConcurrentUpdatePopup();
        } else {
            this.save();
        }
    }

    protected void showConcurrentUpdatePopup() {
        ConcurrentChangePopup.newConcurrentUpdate((Path)this.concurrentUpdateSessionInfo.getPath(), (User)this.concurrentUpdateSessionInfo.getIdentity(), (Command)new Command(){

            public void execute() {
                BaseEditor.this.save();
            }
        }, (Command)new Command(){

            public void execute() {
            }
        }, (Command)new Command(){

            public void execute() {
                BaseEditor.this.reload();
            }
        }).show();
    }

    protected RemoteCallback<Path> getSaveSuccessCallback(final int newHash) {
        return new RemoteCallback<Path>(){

            public void callback(Path path) {
                BaseEditor.this.baseView.hideBusyIndicator();
                BaseEditor.this.versionRecordManager.reloadVersions(path);
                BaseEditor.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemSavedSuccessfully()));
                BaseEditor.this.setOriginalHash(newHash);
            }
        };
    }

    public void onRestore(@Observes RestoreEvent restore) {
        if (this.versionRecordManager.getCurrentPath() == null || restore == null || restore.getPath() == null) {
            return;
        }
        if (this.versionRecordManager.getCurrentPath().equals(restore.getPath())) {
            this.init(this.versionRecordManager.getPathToLatest(), this.place, this.type, false, this.displayShowMoreVersions, new MenuItems[0]);
            this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemRestored()));
        }
    }

    public void reload() {
        this.concurrentUpdateSessionInfo = null;
        this.refreshTitle();
        this.baseView.showBusyIndicator(CommonConstants.INSTANCE.Loading());
        this.loadContent();
        this.changeTitleNotification.fire((Object)new ChangeTitleWidgetEvent(this.place, this.getTitleText(), this.getTitle()));
    }

    private void disableMenus() {
        this.disableMenuItem(MenuItems.COPY);
        this.disableMenuItem(MenuItems.RENAME);
        this.disableMenuItem(MenuItems.DELETE);
        this.disableMenuItem(MenuItems.VALIDATE);
    }

    private void disableMenuItem(MenuItems menuItem) {
        if (this.menus.getItemsMap().containsKey((Object)menuItem)) {
            ((MenuItem)this.menus.getItemsMap().get((Object)menuItem)).setEnabled(false);
        }
    }

    protected Command onValidate() {
        return new Command(){

            public void execute() {
            }
        };
    }

    protected abstract void loadContent();

    protected void save() {
    }

    protected Caller<? extends SupportsDelete> getDeleteServiceCaller() {
        return null;
    }

    protected Caller<? extends SupportsRename> getRenameServiceCaller() {
        return null;
    }

    protected Caller<? extends SupportsCopy> getCopyServiceCaller() {
        return null;
    }

    public boolean mayClose(Integer currentHash) {
        if (this.isDirty(currentHash)) {
            return this.baseView.confirmClose();
        }
        return true;
    }

    public boolean isDirty(Integer currentHash) {
        if (this.originalHash == null) {
            return currentHash != null;
        }
        return !this.originalHash.equals(currentHash);
    }

    public VersionRecordManager getVersionRecordManager() {
        return this.versionRecordManager;
    }
}

