/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.popups;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.event.Event;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.mvp.SaveInProgressEvent;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.commons.ToggleCommentPresenter;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=MockitoJUnitRunner.class)
public class SavePopUpPresenterTest {
    @Mock
    Event<SaveInProgressEvent> saveInProgressEvent;
    @Mock
    SavePopUpPresenter.View view;
    @Mock
    ParameterizedCommand<String> command;
    @Mock
    Path path;
    @Mock
    ToggleCommentPresenter toggleCommentPresenter;
    SavePopUpPresenter presenter;

    @Before
    public void init() throws Exception {
        this.presenter = new SavePopUpPresenter(this.view, this.saveInProgressEvent, this.toggleCommentPresenter);
    }

    @Test
    public void testSetup() throws Exception {
        this.presenter.setup();
        ((SavePopUpPresenter.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
    }

    @Test
    public void testShowWithoutPath() throws Exception {
        this.presenter.show(this.command);
        ((SavePopUpPresenter.View)Mockito.verify((Object)this.view)).show();
        Assert.assertEquals(this.command, (Object)this.presenter.getCommand());
    }

    @Test
    public void testShowWithAPathThatIsVersioned() throws Exception {
        Path versionedPath = this.getVersionedPath();
        this.presenter.show(versionedPath, this.command);
        ((SavePopUpPresenter.View)Mockito.verify((Object)this.view)).show();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.saveInProgressEvent});
    }

    @Test
    public void testShowWithAPathThatIsNotVersioned() throws Exception {
        this.presenter.show(this.path, this.command);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
        ((ParameterizedCommand)Mockito.verify(this.command)).execute((Object)"");
        ((Event)Mockito.verify(this.saveInProgressEvent)).fire((Object)new SaveInProgressEvent((Path)Mockito.any(Path.class)));
    }

    @Test
    public void testSaveWithCommand() throws Exception {
        Mockito.when((Object)this.toggleCommentPresenter.getComment()).thenReturn((Object)"test");
        this.presenter.show(this.command);
        this.presenter.save();
        ((ParameterizedCommand)Mockito.verify(this.command)).execute((Object)"test");
        ((SavePopUpPresenter.View)Mockito.verify((Object)this.view)).hide();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSaveWithoutCommand() throws Exception {
        this.presenter.show(null);
        this.presenter.save();
    }

    private Path getVersionedPath() {
        return PathFactory.newPath((String)"fileName", (String)"uri", (Map)new HashMap<String, Object>(){
            {
                this.put(PathFactory.VERSION_PROPERTY, true);
            }
        });
    }

    @Test
    public void cancel() throws Exception {
        this.presenter.cancel();
        ((SavePopUpPresenter.View)Mockito.verify((Object)this.view)).hide();
    }
}

