/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.impl.ObservablePathImpl;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.BaseEditor;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.version.events.RestoreEvent;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class KieEditorTest {
    private BaseEditor kieEditor;
    private BaseEditorView view;
    private RestoreEvent restoreEvent;
    private ObservablePath observablePath;

    @Before
    public void setUp() throws Exception {
        this.view = (BaseEditorView)Mockito.mock(BaseEditorView.class);
        this.restoreEvent = (RestoreEvent)Mockito.mock(RestoreEvent.class);
        this.kieEditor = (BaseEditor)Mockito.spy((Object)new BaseEditor(this.view){

            protected void loadContent() {
            }

            protected void showVersions() {
            }

            protected void makeMenuBar() {
            }

            protected void showConcurrentUpdatePopup() {
            }
        });
        this.kieEditor.versionRecordManager = (VersionRecordManager)Mockito.mock(VersionRecordManager.class);
        this.kieEditor.notification = new NotificationEventMock();
        this.observablePath = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        ClientResourceType resourceType = (ClientResourceType)Mockito.mock(ClientResourceType.class);
        this.kieEditor.init(this.observablePath, placeRequest, resourceType, new MenuItems[0]);
    }

    @Test
    public void testLoad() throws Exception {
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).loadContent();
    }

    @Test
    public void testSimpleSave() throws Exception {
        this.kieEditor.onSave();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).save();
    }

    @Test
    public void testComplicatedSave() throws Exception {
        this.kieEditor.isReadOnly = false;
        Mockito.when((Object)this.kieEditor.versionRecordManager.isCurrentLatest()).thenReturn((Object)true);
        this.kieEditor.onSave();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).save();
    }

    @Test
    public void testSaveReadOnly() throws Exception {
        this.kieEditor.isReadOnly = true;
        Mockito.when((Object)this.kieEditor.versionRecordManager.isCurrentLatest()).thenReturn((Object)true);
        this.kieEditor.onSave();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor, (VerificationMode)Mockito.never())).save();
        ((BaseEditorView)Mockito.verify((Object)this.view)).alertReadOnly();
    }

    @Test
    public void testRestore() throws Exception {
        this.kieEditor.isReadOnly = true;
        Mockito.when((Object)this.kieEditor.versionRecordManager.isCurrentLatest()).thenReturn((Object)false);
        this.kieEditor.onSave();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor, (VerificationMode)Mockito.never())).save();
        ((VersionRecordManager)Mockito.verify((Object)this.kieEditor.versionRecordManager)).restoreToCurrentVersion();
    }

    @Test
    public void testConcurrentSave() throws Exception {
        this.kieEditor.isReadOnly = false;
        Mockito.when((Object)this.kieEditor.versionRecordManager.isCurrentLatest()).thenReturn((Object)true);
        this.kieEditor.concurrentUpdateSessionInfo = new ObservablePath.OnConcurrentUpdateEvent(){

            public Path getPath() {
                return null;
            }

            public String getId() {
                return null;
            }

            public User getIdentity() {
                return null;
            }
        };
        this.kieEditor.onSave();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor, (VerificationMode)Mockito.never())).save();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).showConcurrentUpdatePopup();
    }

    @Test
    public void testInitResetsConcurrentSessionInfo() throws Exception {
        this.kieEditor.isReadOnly = false;
        Mockito.when((Object)this.kieEditor.versionRecordManager.isCurrentLatest()).thenReturn((Object)true);
        this.kieEditor.concurrentUpdateSessionInfo = new ObservablePath.OnConcurrentUpdateEvent(){

            public Path getPath() {
                return null;
            }

            public String getId() {
                return null;
            }

            public User getIdentity() {
                return null;
            }
        };
        this.kieEditor.init((ObservablePath)new ObservablePathImpl(), this.kieEditor.place, this.kieEditor.type, this.kieEditor.menuItems.toArray(new MenuItems[0]));
        this.kieEditor.onSave();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor, (VerificationMode)Mockito.never())).showConcurrentUpdatePopup();
    }

    @Test
    public void onRestoreShouldInitBaseEditorSuccessfully() throws Exception {
        Mockito.when((Object)this.kieEditor.versionRecordManager.getCurrentPath()).thenReturn((Object)this.observablePath);
        Mockito.when((Object)this.restoreEvent.getPath()).thenReturn((Object)this.observablePath);
        this.kieEditor.onRestore(this.restoreEvent);
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).onRestore(this.restoreEvent);
        ((VersionRecordManager)Mockito.verify((Object)this.kieEditor.versionRecordManager)).getPathToLatest();
    }

    @Test
    public void onRestoreWithNullCurrentPathShouldNotInitEditor() throws Exception {
        Mockito.when((Object)this.kieEditor.versionRecordManager.getCurrentPath()).thenReturn(null);
        this.kieEditor.onRestore(this.restoreEvent);
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).onRestore(this.restoreEvent);
        ((VersionRecordManager)Mockito.verify((Object)this.kieEditor.versionRecordManager, (VerificationMode)Mockito.never())).getPathToLatest();
    }

    @Test
    public void onRestoreWithNullRestoreEventPathShouldNotInitEditor() throws Exception {
        Mockito.when((Object)this.restoreEvent.getPath()).thenReturn(null);
        this.kieEditor.onRestore(this.restoreEvent);
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).onRestore(this.restoreEvent);
        ((VersionRecordManager)Mockito.verify((Object)this.kieEditor.versionRecordManager, (VerificationMode)Mockito.never())).getPathToLatest();
    }

    @Test
    public void onRestoreWithNullRestoreEventShouldNotInitEditor() throws Exception {
        this.kieEditor.onRestore(null);
        Mockito.when((Object)this.kieEditor.versionRecordManager.getPathToLatest()).thenReturn((Object)new ObservablePathImpl());
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).onRestore((RestoreEvent)Matchers.any());
        ((VersionRecordManager)Mockito.verify((Object)this.kieEditor.versionRecordManager, (VerificationMode)Mockito.never())).getPathToLatest();
    }

    @Test
    public void testOnValidateMethodIsCalled() throws Exception {
        this.kieEditor.onValidate();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).onValidate();
    }

    public static class NotificationEventMock
    extends EventSourceMock<NotificationEvent> {
        public void fire(NotificationEvent event) {
        }
    }
}

