/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.popups;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.editor.commons.client.file.RestoreUtil;
import org.uberfire.ext.editor.commons.client.file.popups.commons.ToggleCommentPresenter;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.editor.commons.version.VersionService;
import org.uberfire.ext.editor.commons.version.events.RestoreEvent;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class RestorePopUpPresenter {
    private BusyIndicatorView busyIndicatorView;
    private Caller<VersionService> versionService;
    private Event<RestoreEvent> restoreEvent;
    private RestoreUtil restoreUtil;
    private View view;
    protected ParameterizedCommand<String> command;
    private ToggleCommentPresenter toggleCommentPresenter;

    @Inject
    public RestorePopUpPresenter(View view, BusyIndicatorView busyIndicatorView, Caller<VersionService> versionService, Event<RestoreEvent> restoreEvent, RestoreUtil restoreUtil, ToggleCommentPresenter toggleCommentPresenter) {
        this.view = view;
        this.busyIndicatorView = busyIndicatorView;
        this.versionService = versionService;
        this.restoreEvent = restoreEvent;
        this.restoreUtil = restoreUtil;
        this.toggleCommentPresenter = toggleCommentPresenter;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void restore() {
        this.command.execute((Object)this.toggleCommentPresenter.getComment());
        this.view.hide();
    }

    public void show(ObservablePath currentPath, String currentVersionRecordUri) {
        this.command = this.restoreCommand(currentPath, currentVersionRecordUri);
        this.view.show();
    }

    public void cancel() {
        this.view.hide();
    }

    public ToggleCommentPresenter getToggleCommentPresenter() {
        return this.toggleCommentPresenter;
    }

    private HasBusyIndicatorDefaultErrorCallback errorCallback() {
        return new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView);
    }

    private RemoteCallback<Path> successCallback(String currentVersionRecordUri) {
        return restored -> {
            this.busyIndicatorView.hideBusyIndicator();
            this.restoreEvent.fire((Object)new RestoreEvent(this.restoreUtil.createObservablePath((Path)restored, currentVersionRecordUri)));
        };
    }

    ParameterizedCommand<String> restoreCommand(ObservablePath currentPath, String currentVersionRecordUri) {
        return comment -> {
            this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Restoring());
            ((VersionService)this.versionService.call(this.successCallback(currentVersionRecordUri), (ErrorCallback)this.errorCallback())).restore((Path)currentPath, comment);
        };
    }

    public static interface View
    extends UberElement<RestorePopUpPresenter> {
        public void show();

        public void hide();
    }
}

