/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.history;

import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.editor.commons.client.history.VersionMenuDropDownButtonView;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.mvp.Command;

public class VersionMenuDropDownButton
implements VersionMenuDropDownButtonView.Presenter,
HasEnabled,
IsWidget {
    private List<VersionRecord> versions;
    private Callback<VersionRecord> selectionCallback;
    private Command showMore;
    private String version;
    private VersionMenuDropDownButtonView view;

    public VersionMenuDropDownButton() {
    }

    @Inject
    public VersionMenuDropDownButton(VersionMenuDropDownButtonView view) {
        this.view = view;
        view.setPresenter(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void setItems(List<VersionRecord> versions) {
        if (this.versions == null || versions.size() > this.versions.size()) {
            this.versions = versions;
        }
        this.updateTitle();
    }

    @Override
    public void onMenuOpening() {
        PortablePreconditions.checkNotNull((String)"version", (Object)this.version);
        PortablePreconditions.checkNotNull((String)"versions", this.versions);
        this.view.clear();
        boolean currentHasBeenAdded = false;
        int versionIndex = this.versions.size();
        ArrayList<VersionRecord> reversedList = new ArrayList<VersionRecord>(this.versions);
        Collections.reverse(reversedList);
        int versionsDisplayed = 0;
        for (VersionRecord versionRecord : reversedList) {
            boolean isSelected = this.isSelected(versionRecord);
            if (isSelected) {
                currentHasBeenAdded = true;
            }
            if (versionIndex <= this.versions.size() - 7 && this.versions.size() > 7) {
                if (!currentHasBeenAdded) {
                    this.view.addLabel(this.getCurrentVersionRecord(), true, this.getCurrentVersionIndex());
                    ++versionsDisplayed;
                }
                this.addShowMoreLabel(versionsDisplayed);
                break;
            }
            this.view.addLabel(versionRecord, isSelected, versionIndex);
            --versionIndex;
            ++versionsDisplayed;
        }
    }

    @Override
    public void resetVersions() {
        this.versions = null;
        this.version = null;
    }

    private void updateTitle() {
        if (this.versions != null && this.version != null) {
            if (!this.versions.isEmpty() && this.version.equals(this.versions.get(this.versions.size() - 1).id())) {
                this.view.setTextToLatest();
            } else {
                this.view.setTextToVersion(this.getCurrentVersionIndex());
            }
        }
    }

    private VersionRecord getCurrentVersionRecord() {
        for (VersionRecord versionRecord : this.versions) {
            if (!versionRecord.id().equals(this.version)) continue;
            return versionRecord;
        }
        return null;
    }

    private int getCurrentVersionIndex() {
        for (int i = 0; i < this.versions.size(); ++i) {
            if (!this.versions.get(i).id().equals(this.version)) continue;
            return i + 1;
        }
        return -1;
    }

    private boolean isSelected(VersionRecord versionRecord) {
        return versionRecord.id().equals(this.version);
    }

    private void addShowMoreLabel(int versionIndex) {
        this.view.addViewAllLabel(this.versions.size() - versionIndex, new Command(){

            public void execute() {
                VersionMenuDropDownButton.this.showMore.execute();
            }
        });
    }

    public void addSelectionCallback(Callback<VersionRecord> selectionCallback) {
        this.selectionCallback = selectionCallback;
    }

    public void setShowMoreCommand(Command showMore) {
        this.showMore = showMore;
    }

    public void setVersion(String version) {
        this.version = version;
        this.updateTitle();
    }

    @Override
    public void onVersionRecordSelected(VersionRecord result) {
        if (this.selectionCallback != null) {
            this.selectionCallback.callback((Object)result);
        }
    }

    public boolean isEnabled() {
        return this.view.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.view.setEnabled(enabled);
    }
}

