/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.exports;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.editor.commons.client.file.exports.FileExportProducer;
import org.uberfire.ext.editor.commons.client.file.exports.ImageFileExport;
import org.uberfire.ext.editor.commons.client.file.exports.PdfFileExport;
import org.uberfire.ext.editor.commons.client.file.exports.TextFileExport;
import org.uberfire.ext.editor.commons.client.file.exports.jso.FileExportScriptInjector;

@RunWith(value=MockitoJUnitRunner.class)
public class FileExportProducerTest {
    private FileExportProducer fs;
    @Mock
    private FileExportScriptInjector scriptInjector;

    @Before
    public void setup() {
        this.fs = new FileExportProducer(this.scriptInjector);
    }

    @Test
    public void testInit() {
        this.fs.init();
        ((FileExportScriptInjector)Mockito.verify((Object)this.scriptInjector, (VerificationMode)Mockito.times((int)1))).inject();
    }

    @Test
    public void ProduceTextFileSaverTest() {
        TextFileExport textFileSaver = this.fs.forText();
        Assert.assertNotNull((Object)textFileSaver);
    }

    @Test
    public void producePDFFileSaverTest() {
        PdfFileExport pdfFileSaver = this.fs.forPDF();
        Assert.assertNotNull((Object)pdfFileSaver);
    }

    @Test
    public void produceImageFileSaver() {
        ImageFileExport imageFileSaver = this.fs.forImage();
        Assert.assertNotNull((Object)imageFileSaver);
    }
}

