/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.menu;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.UpdatedLockStatusEvent;
import org.uberfire.ext.editor.commons.client.file.popups.CopyPopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.DeletePopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.RenamePopUpPresenter;
import org.uberfire.ext.editor.commons.client.history.SaveButton;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilderImpl;
import org.uberfire.ext.editor.commons.client.menu.HasLockSyncMenuStateHelper;
import org.uberfire.ext.editor.commons.client.menu.RestoreVersionCommandProvider;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.service.support.SupportsCopy;
import org.uberfire.ext.editor.commons.service.support.SupportsDelete;
import org.uberfire.ext.editor.commons.service.support.SupportsRename;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class BasicFileMenuBuilderTest {
    @Mock
    private Path mockPath;
    @Mock
    private BasicFileMenuBuilder.PathProvider provider;
    @Mock
    private Validator validator;
    @Mock
    private RestoreVersionCommandProvider restoreVersionCommandProvider;
    @Mock
    private EventSourceMock<NotificationEvent> notification;
    @Mock
    private BusyIndicatorView busyIndicatorView;
    @Mock
    private DeletePopUpPresenter deletePopUpPresenter;
    @Mock
    private CopyPopUpPresenter copyPopUpPresenter;
    @Mock
    private RenamePopUpPresenter renamePopUpPresenter;
    @Mock
    private SupportsDelete deleteService;
    private CallerMock<SupportsDelete> deleteCaller;
    @Mock
    private SupportsRename renameService;
    private CallerMock<SupportsRename> renameCaller;
    @Mock
    private SupportsCopy copyService;
    private CallerMock<SupportsCopy> copyCaller;
    private BasicFileMenuBuilderImpl builder;

    @Before
    public void setup() {
        this.builder = new BasicFileMenuBuilderImpl(this.deletePopUpPresenter, this.copyPopUpPresenter, this.renamePopUpPresenter, this.busyIndicatorView, this.notification, this.restoreVersionCommandProvider);
        this.deleteCaller = new CallerMock((Object)this.deleteService);
        this.renameCaller = new CallerMock((Object)this.renameService);
        Mockito.when((Object)this.provider.getPath()).thenReturn((Object)this.mockPath);
    }

    @Test
    public void testDelete() {
        this.builder.addDelete(this.provider, this.deleteCaller);
        Menus menus = this.builder.build();
        MenuItem mi = (MenuItem)menus.getItems().get(0);
        MenuItemCommand mic = (MenuItemCommand)mi;
        ((BasicFileMenuBuilder.PathProvider)Mockito.verify((Object)this.provider, (VerificationMode)Mockito.never())).getPath();
        mic.getCommand().execute();
        ((BasicFileMenuBuilder.PathProvider)Mockito.verify((Object)this.provider, (VerificationMode)Mockito.times((int)1))).getPath();
    }

    @Test
    public void testRename() {
        this.builder.addRename(this.provider, this.validator, this.renameCaller);
        Menus menus = this.builder.build();
        MenuItem mi = (MenuItem)menus.getItems().get(0);
        MenuItemCommand mic = (MenuItemCommand)mi;
        ((BasicFileMenuBuilder.PathProvider)Mockito.verify((Object)this.provider, (VerificationMode)Mockito.never())).getPath();
        mic.getCommand().execute();
        ((BasicFileMenuBuilder.PathProvider)Mockito.verify((Object)this.provider, (VerificationMode)Mockito.times((int)1))).getPath();
    }

    @Test
    public void testCopy() {
        this.builder.addCopy(this.provider, this.validator, this.copyCaller);
        Menus menus = this.builder.build();
        MenuItem mi = (MenuItem)menus.getItems().get(0);
        MenuItemCommand mic = (MenuItemCommand)mi;
        ((BasicFileMenuBuilder.PathProvider)Mockito.verify((Object)this.provider, (VerificationMode)Mockito.never())).getPath();
        mic.getCommand().execute();
        ((BasicFileMenuBuilder.PathProvider)Mockito.verify((Object)this.provider, (VerificationMode)Mockito.times((int)1))).getPath();
    }

    @Test
    public void menuItemsDisabledWhenLockedByDifferentUser() {
        this.builder.addSave((MenuItem)new MockSaveButton());
        this.builder.addRename((Command)Mockito.mock(Command.class));
        this.builder.addDelete((Command)Mockito.mock(Command.class));
        Menus menus = this.builder.build();
        UpdatedLockStatusEvent event = new UpdatedLockStatusEvent((Path)Mockito.mock(Path.class), true, false);
        this.builder.onEditorLockInfo(event);
        this.assertMenuItemEnabled((MenuItem)menus.getItems().get(0), false);
        this.assertMenuItemEnabled((MenuItem)menus.getItems().get(1), false);
        this.assertMenuItemEnabled((MenuItem)menus.getItems().get(2), false);
    }

    @Test
    public void menuItemsEnabledWhenNotLocked() {
        this.builder.addSave((MenuItem)new MockSaveButton());
        this.builder.addRename((Command)Mockito.mock(Command.class));
        this.builder.addDelete((Command)Mockito.mock(Command.class));
        Menus menus = this.builder.build();
        UpdatedLockStatusEvent event = new UpdatedLockStatusEvent((Path)Mockito.mock(Path.class), false, false);
        this.builder.onEditorLockInfo(event);
        this.assertMenuItemEnabled((MenuItem)menus.getItems().get(0), true);
        this.assertMenuItemEnabled((MenuItem)menus.getItems().get(1), true);
        this.assertMenuItemEnabled((MenuItem)menus.getItems().get(2), true);
    }

    @Test
    public void menuItemsEnabledWhenLockedByCurrentUser() {
        this.builder.addSave((MenuItem)new MockSaveButton());
        this.builder.addRename((Command)Mockito.mock(Command.class));
        this.builder.addDelete((Command)Mockito.mock(Command.class));
        Menus menus = this.builder.build();
        UpdatedLockStatusEvent event = new UpdatedLockStatusEvent((Path)Mockito.mock(Path.class), true, true);
        this.builder.onEditorLockInfo(event);
        this.assertMenuItemEnabled((MenuItem)menus.getItems().get(0), true);
        this.assertMenuItemEnabled((MenuItem)menus.getItems().get(1), true);
        this.assertMenuItemEnabled((MenuItem)menus.getItems().get(2), true);
    }

    @Test
    public void menuItemsDisabledWhenNotLockedWithCustomStateHelper() {
        this.builder.addSave((MenuItem)new MockSaveButton());
        this.builder.addRename((Command)Mockito.mock(Command.class));
        this.builder.addDelete((Command)Mockito.mock(Command.class));
        this.builder.setLockSyncMenuStateHelper((file, isLocked, isLockedByCurrentUser) -> HasLockSyncMenuStateHelper.LockSyncMenuStateHelper.Operation.DISABLE);
        Menus menus = this.builder.build();
        UpdatedLockStatusEvent event = new UpdatedLockStatusEvent((Path)Mockito.mock(Path.class), false, false);
        this.builder.onEditorLockInfo(event);
        this.assertMenuItemEnabled((MenuItem)menus.getItems().get(0), false);
        this.assertMenuItemEnabled((MenuItem)menus.getItems().get(1), false);
        this.assertMenuItemEnabled((MenuItem)menus.getItems().get(2), false);
    }

    @Test
    public void menuItemsStateChangeVetoedWhenLockedWithCustomStateHelper() {
        this.builder.addSave((MenuItem)new MockSaveButton());
        this.builder.addRename((Command)Mockito.mock(Command.class));
        this.builder.addDelete((Command)Mockito.mock(Command.class));
        this.builder.setLockSyncMenuStateHelper((file, isLocked, isLockedByCurrentUser) -> HasLockSyncMenuStateHelper.LockSyncMenuStateHelper.Operation.VETO);
        Menus menus = this.builder.build();
        ((MenuItem)menus.getItems().get(0)).setEnabled(true);
        ((MenuItem)menus.getItems().get(1)).setEnabled(true);
        ((MenuItem)menus.getItems().get(2)).setEnabled(true);
        UpdatedLockStatusEvent event = new UpdatedLockStatusEvent((Path)Mockito.mock(Path.class), true, false);
        this.builder.onEditorLockInfo(event);
        this.assertMenuItemEnabled((MenuItem)menus.getItems().get(0), true);
        this.assertMenuItemEnabled((MenuItem)menus.getItems().get(1), true);
        this.assertMenuItemEnabled((MenuItem)menus.getItems().get(2), true);
    }

    private void assertMenuItemEnabled(MenuItem menuItem, boolean enabled) {
        Assert.assertEquals((Object)enabled, (Object)menuItem.isEnabled());
    }

    private class MockSaveButton
    extends SaveButton {
        private boolean enabled;

        private MockSaveButton() {
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

