/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.exports.jso;

import com.google.gwt.core.client.ScriptInjector;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import org.uberfire.ext.editor.commons.client.file.exports.FileExportResources;

@ApplicationScoped
public class FileExportScriptInjector {
    public static final String NS = "org.uberfire.ext.editor.commons.client.file.exports.jso.";
    public static final String NS_SEPARATOR = ".";
    public static final String JS_OBJ_SUFFIX = " || {};";
    private final Consumer<String> scriptInjector;

    public FileExportScriptInjector() {
        this.scriptInjector = FileExportScriptInjector::inject;
    }

    FileExportScriptInjector(Consumer<String> scriptInjector) {
        this.scriptInjector = scriptInjector;
    }

    public void inject() {
        String fileSaver = this.getFileSaverSource();
        String jsPdf = this.getJsPdfSource();
        this.scriptInjector.accept("var " + fileSaver + "\n" + jsPdf + "\n");
    }

    private String getFileSaverSource() {
        String fsScript = FileExportResources.INSTANCE.fileSaver().getText();
        String fsNsObject = FileExportScriptInjector.buildNamespaceObject("org.uberfire.ext.editor.commons.client.file.exports.jso.JsFileSaver.saveAs");
        return fsNsObject + " = function(blob, fileName) {\n" + fsScript + "\nreturn saveAs(blob, fileName);};";
    }

    private String getJsPdfSource() {
        String jsPdfScript = FileExportResources.INSTANCE.jsPdf().getText();
        String jsPdfNsObject = FileExportScriptInjector.buildNamespaceObject("org.uberfire.ext.editor.commons.client.file.exports.jso.JsPdf");
        return jsPdfNsObject + " = function(settings) {\n" + jsPdfScript + "\nvar saveAs = " + NS + "JsFileSaver.saveAs; return new jsPDF(settings);};";
    }

    private static void inject(String raw) {
        ScriptInjector.FromString jsPdfScript = ScriptInjector.fromString((String)raw);
        jsPdfScript.setWindow(ScriptInjector.TOP_WINDOW).setRemoveTag(false).inject();
    }

    static String buildNamespaceObject(String namespace) {
        int pkgSepIndex = namespace.lastIndexOf(NS_SEPARATOR);
        String raw = "";
        if (pkgSepIndex > 0) {
            String nsPkg = namespace.substring(0, pkgSepIndex);
            String[] nsPkgObject = new String[]{"", ""};
            Arrays.asList(nsPkg.split("\\.")).forEach(p -> {
                nsPkgObject[0] = nsPkgObject[0] + p;
                nsPkgObject[1] = nsPkgObject[1] + nsPkgObject[0] + " = " + nsPkgObject[0] + JS_OBJ_SUFFIX + "\n";
                nsPkgObject[0] = nsPkgObject[0] + NS_SEPARATOR;
            });
            raw = nsPkgObject[1];
        }
        raw = raw + namespace;
        return raw;
    }
}

