/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.htmleditor;

import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.BaseEditor;
import org.uberfire.ext.editor.commons.client.htmleditor.HtmlEditorPresenter;
import org.uberfire.ext.editor.commons.client.htmleditor.HtmlResourceType;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.support.SupportsCopy;
import org.uberfire.ext.editor.commons.service.support.SupportsDelete;
import org.uberfire.ext.editor.commons.service.support.SupportsRename;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="HtmlEditor", supportedTypes={HtmlResourceType.class})
public class HtmlEditor
extends BaseEditor {
    private HtmlResourceType htmlResourceType;
    private HtmlEditorPresenter editor;
    private Caller<VFSService> vfsServices;
    private Caller<DeleteService> deleteService;
    private Caller<RenameService> renameService;
    private Caller<CopyService> copyService;

    @Inject
    public HtmlEditor(HtmlResourceType htmlResourceType, HtmlEditorPresenter editor, Caller<VFSService> vfsServices, Caller<DeleteService> deleteService, Caller<RenameService> renameService, Caller<CopyService> copyService) {
        super(editor.getView());
        this.htmlResourceType = htmlResourceType;
        this.editor = editor;
        this.vfsServices = vfsServices;
        this.deleteService = deleteService;
        this.renameService = renameService;
        this.copyService = copyService;
    }

    @PostConstruct
    public void init() {
        this.editor.load();
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        this.init(path, place, (ClientResourceType)this.htmlResourceType, MenuItems.SAVE, MenuItems.COPY, MenuItems.RENAME, MenuItems.DELETE);
    }

    @Override
    protected void loadContent() {
        this.baseView.hideBusyIndicator();
        ((VFSService)this.vfsServices.call((RemoteCallback)new RemoteCallback<String>(){

            public void callback(String htmlContent) {
                HtmlEditor.this.editor.setContent(htmlContent);
            }
        })).readAllString((Path)this.versionRecordManager.getCurrentPath());
    }

    @Override
    protected void save() {
        String htmlContent = this.editor.getContent();
        ((VFSService)this.vfsServices.call(this.getSaveSuccessCallback(htmlContent.hashCode()))).write((Path)this.versionRecordManager.getCurrentPath(), htmlContent);
        this.concurrentUpdateSessionInfo = null;
    }

    @Override
    protected Caller<? extends SupportsDelete> getDeleteServiceCaller() {
        return this.deleteService;
    }

    @Override
    protected Caller<? extends SupportsRename> getRenameServiceCaller() {
        return this.renameService;
    }

    @Override
    protected Caller<? extends SupportsCopy> getCopyServiceCaller() {
        return this.copyService;
    }

    @Override
    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @Override
    @WorkbenchPartTitle
    public String getTitleText() {
        return CommonConstants.INSTANCE.HtmlEditor() + " [" + this.versionRecordManager.getCurrentPath().getFileName() + "]";
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return this.editor.getView();
    }
}

