/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.exports.jso;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.editor.commons.client.file.exports.FileExportResources;
import org.uberfire.ext.editor.commons.client.file.exports.jso.FileExportScriptInjector;
import org.uberfire.ext.editor.commons.client.file.exports.jso.JsFileSaver;
import org.uberfire.ext.editor.commons.client.file.exports.jso.JsPdf;

@RunWith(value=GwtMockitoTestRunner.class)
public class FileExportScriptInjectorTest {
    private FileExportScriptInjector tested;
    @Mock
    private Consumer<String> scriptInjector;

    @Before
    public void setup() {
        this.tested = new FileExportScriptInjector(this.scriptInjector);
    }

    @Test
    public void testInject() {
        this.tested.inject();
        ArgumentCaptor scriptCaptor = ArgumentCaptor.forClass(String.class);
        ((Consumer)Mockito.verify(this.scriptInjector, (VerificationMode)Mockito.times((int)1))).accept(scriptCaptor.capture());
        String script = (String)scriptCaptor.getValue();
        String fsNsObject = FileExportScriptInjector.buildNamespaceObject((String)(JsFileSaver.class.getName() + ".saveAs"));
        String jsPdfNsObject = FileExportScriptInjector.buildNamespaceObject((String)JsPdf.class.getName());
        String c2sNsObject = FileExportResources.INSTANCE.canvas2svg().getText();
        Assert.assertEquals((Object)("var " + fsNsObject + " = function(blob, fileName, disableAutoBOM) {\nfileSaver\nreturn saveAs(blob, fileName, disableAutoBOM);};\n" + jsPdfNsObject + " = function(settings) {\njsPdf\nvar saveAs = org.uberfire.ext.editor.commons.client.file.exports.jso.JsFileSaver.saveAs; return new jsPDF(settings);};\n" + c2sNsObject + "\n"), (Object)script);
    }

    @Test
    public void testNamespaces() {
        Assert.assertEquals((Object)"org = org || {};\norg.uberfire = org.uberfire || {};\norg.uberfire.ext = org.uberfire.ext || {};\norg.uberfire.ext.editor = org.uberfire.ext.editor || {};\norg.uberfire.ext.editor.commons = org.uberfire.ext.editor.commons || {};\norg.uberfire.ext.editor.commons.client = org.uberfire.ext.editor.commons.client || {};\norg.uberfire.ext.editor.commons.client.file = org.uberfire.ext.editor.commons.client.file || {};\norg.uberfire.ext.editor.commons.client.file.exports = org.uberfire.ext.editor.commons.client.file.exports || {};\norg.uberfire.ext.editor.commons.client.file.exports.jso = org.uberfire.ext.editor.commons.client.file.exports.jso || {};\norg.uberfire.ext.editor.commons.client.file.exports.jso.JsFileSaver", (Object)FileExportScriptInjector.buildNamespaceObject((String)JsFileSaver.class.getName()));
        Assert.assertEquals((Object)"org = org || {};\norg.uberfire = org.uberfire || {};\norg.uberfire.ext = org.uberfire.ext || {};\norg.uberfire.ext.editor = org.uberfire.ext.editor || {};\norg.uberfire.ext.editor.commons = org.uberfire.ext.editor.commons || {};\norg.uberfire.ext.editor.commons.client = org.uberfire.ext.editor.commons.client || {};\norg.uberfire.ext.editor.commons.client.file = org.uberfire.ext.editor.commons.client.file || {};\norg.uberfire.ext.editor.commons.client.file.exports = org.uberfire.ext.editor.commons.client.file.exports || {};\norg.uberfire.ext.editor.commons.client.file.exports.jso = org.uberfire.ext.editor.commons.client.file.exports.jso || {};\norg.uberfire.ext.editor.commons.client.file.exports.jso.JsPdf", (Object)FileExportScriptInjector.buildNamespaceObject((String)JsPdf.class.getName()));
        Assert.assertEquals((Object)"nonamespace", (Object)FileExportScriptInjector.buildNamespaceObject((String)"nonamespace"));
    }
}

