/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.menu;

import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.net.URL;
import java.util.function.Supplier;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.menu.DownloadMenuItem;
import org.uberfire.mvp.Command;

@WithClassesToStub(value={URL.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class DownloadMenuItemTest {
    @Mock
    private TranslationService translationService;
    @Mock
    private Path path;
    private Supplier<Path> pathSupplier = () -> this.path;
    private DownloadMenuItem downloadMenuItem;

    @Before
    public void setup() {
        this.downloadMenuItem = (DownloadMenuItem)Mockito.spy((Object)new DownloadMenuItem(this.translationService));
    }

    @Test
    public void testBuild() {
        String caption = "Download";
        Command menuItemCommand = () -> {};
        Mockito.when((Object)this.translationService.format("DownloadMenuItem.Download", new Object[0])).thenReturn((Object)"Download");
        ((DownloadMenuItem)Mockito.doReturn((Object)menuItemCommand).when((Object)this.downloadMenuItem)).makeMenuItemCommand(this.pathSupplier);
        this.downloadMenuItem.build(this.pathSupplier);
        ((DownloadMenuItem)Mockito.verify((Object)this.downloadMenuItem)).makeMenuItem((String)Matchers.eq((Object)"Download"), (Command)Matchers.eq((Object)menuItemCommand));
    }

    @Test
    public void testMenuItemCommand() {
        Command command = this.downloadMenuItem.makeMenuItemCommand(this.pathSupplier);
        ((DownloadMenuItem)Mockito.doNothing().when((Object)this.downloadMenuItem)).open((String)Matchers.any());
        command.execute();
        ((DownloadMenuItem)Mockito.verify((Object)this.downloadMenuItem)).download(this.pathSupplier);
    }

    @Test
    public void testDownload() {
        String expectedDownloadURL = "defaulteditor/download?path=default://master@MySpace/Mortgages/src/main/resources/rule.drl";
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)"default://master@MySpace/Mortgages/src/main/resources/rule.drl");
        ((DownloadMenuItem)Mockito.doNothing().when((Object)this.downloadMenuItem)).open((String)Matchers.any());
        this.downloadMenuItem.download(this.pathSupplier);
        ((DownloadMenuItem)Mockito.verify((Object)this.downloadMenuItem)).open((String)Matchers.eq((Object)"defaulteditor/download?path=default://master@MySpace/Mortgages/src/main/resources/rule.drl"));
    }
}

