/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.htmleditor;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.BaseEditor;
import org.uberfire.ext.editor.commons.client.htmleditor.HtmlEditorPresenter;
import org.uberfire.ext.editor.commons.client.htmleditor.HtmlResourceType;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.editor.commons.file.DefaultMetadata;
import org.uberfire.ext.editor.commons.service.htmleditor.HtmlEditorService;
import org.uberfire.ext.editor.commons.service.support.SupportsCopy;
import org.uberfire.ext.editor.commons.service.support.SupportsDelete;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="HtmlEditor", supportedTypes={HtmlResourceType.class})
public class HtmlEditor
extends BaseEditor<String, DefaultMetadata> {
    private HtmlResourceType htmlResourceType;
    private HtmlEditorPresenter editor;
    private Caller<HtmlEditorService> htmlEditorService;

    @Inject
    public HtmlEditor(HtmlResourceType htmlResourceType, HtmlEditorPresenter editor, Caller<HtmlEditorService> htmlEditorService) {
        super(editor.getView());
        this.htmlResourceType = htmlResourceType;
        this.editor = editor;
        this.htmlEditorService = htmlEditorService;
    }

    @PostConstruct
    public void init() {
        this.editor.load();
    }

    @Override
    protected Supplier<String> getContentSupplier() {
        return this.editor::getContent;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        this.init(path, place, (ClientResourceType)this.htmlResourceType, MenuItems.SAVE, MenuItems.COPY, MenuItems.RENAME, MenuItems.DELETE);
    }

    @Override
    protected void loadContent() {
        this.baseView.hideBusyIndicator();
        ((HtmlEditorService)this.htmlEditorService.call(htmlContent -> this.editor.setContent((String)htmlContent))).load((Path)this.versionRecordManager.getCurrentPath());
    }

    @Override
    protected void save() {
        String htmlContent = this.editor.getContent();
        ((HtmlEditorService)this.htmlEditorService.call(this.getSaveSuccessCallback(htmlContent.hashCode()))).save((Path)this.versionRecordManager.getCurrentPath(), (Object)htmlContent, null, null);
        this.concurrentUpdateSessionInfo = null;
    }

    @Override
    protected Caller<? extends SupportsDelete> getDeleteServiceCaller() {
        return this.htmlEditorService;
    }

    @Override
    protected Caller<? extends SupportsSaveAndRename<String, DefaultMetadata>> getSaveAndRenameServiceCaller() {
        return this.htmlEditorService;
    }

    @Override
    protected Caller<? extends SupportsCopy> getCopyServiceCaller() {
        return this.htmlEditorService;
    }

    @Override
    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @Override
    @WorkbenchPartTitle
    public String getTitleText() {
        return CommonConstants.INSTANCE.HtmlEditor() + " [" + this.versionRecordManager.getCurrentPath().getFileName() + "]";
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return this.editor.getView();
    }
}

