/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.exports;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.ext.editor.commons.client.file.exports.ImageDataUriContent;

public class ImageDataUriContentTest {
    private ImageDataUriContent imageContent;

    @Before
    public void setup() {
    }

    @Test
    public void testPng() {
        this.imageContent = ImageDataUriContent.create((String)"data:image/png;base64,9j/4AAQSkZJRgABAQEASABIAAD");
        Assert.assertEquals((Object)"data:image/png;base64,9j/4AAQSkZJRgABAQEASABIAAD", (Object)this.imageContent.getUri());
        Assert.assertEquals((Object)"image/png", (Object)this.imageContent.getMimeType());
        Assert.assertEquals((Object)"9j/4AAQSkZJRgABAQEASABIAAD", (Object)this.imageContent.getData());
    }

    @Test
    public void testJpg() {
        this.imageContent = ImageDataUriContent.create((String)"data:image/jpg;base64,9j/4AAQSkZJRgABAQEASABIAAD");
        Assert.assertEquals((Object)"data:image/jpg;base64,9j/4AAQSkZJRgABAQEASABIAAD", (Object)this.imageContent.getUri());
        Assert.assertEquals((Object)"image/jpg", (Object)this.imageContent.getMimeType());
        Assert.assertEquals((Object)"9j/4AAQSkZJRgABAQEASABIAAD", (Object)this.imageContent.getData());
    }

    @Test
    public void testOtherTypes() {
        this.imageContent = ImageDataUriContent.create((String)"data:image/svg;base64,9j/4AAQSkZJRgABAQEASABIAAD");
        Assert.assertEquals((Object)"data:image/svg;base64,9j/4AAQSkZJRgABAQEASABIAAD", (Object)this.imageContent.getUri());
        Assert.assertEquals((Object)"image/svg", (Object)this.imageContent.getMimeType());
        Assert.assertEquals((Object)"9j/4AAQSkZJRgABAQEASABIAAD", (Object)this.imageContent.getData());
        this.imageContent = ImageDataUriContent.create((String)"data:image/svg,9j/4AAQSkZJRgABAQEASABIAAD");
        Assert.assertEquals((Object)"data:image/svg,9j/4AAQSkZJRgABAQEASABIAAD", (Object)this.imageContent.getUri());
        Assert.assertEquals((Object)"image/svg", (Object)this.imageContent.getMimeType());
        Assert.assertEquals((Object)"9j/4AAQSkZJRgABAQEASABIAAD", (Object)this.imageContent.getData());
    }
}

