/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.exports;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.editor.commons.client.file.exports.PdfDocument;
import org.uberfire.ext.editor.commons.file.exports.PdfExportPreferences;

public class PdfDocumentTest {
    @Test
    public void testText() {
        PdfDocument document = PdfDocument.create((PdfExportPreferences)PdfExportPreferences.create((PdfExportPreferences.Orientation)PdfExportPreferences.Orientation.PORTRAIT, (PdfExportPreferences.Unit)PdfExportPreferences.Unit.MM, (PdfExportPreferences.Format)PdfExportPreferences.Format.A4));
        document.addText("text1", 13, 453);
        Assert.assertEquals((Object)PdfExportPreferences.Orientation.PORTRAIT, (Object)document.getSettings().getOrientation());
        Assert.assertEquals((Object)PdfExportPreferences.Unit.MM, (Object)document.getSettings().getUnit());
        Assert.assertEquals((Object)PdfExportPreferences.Format.A4, (Object)document.getSettings().getFormat());
        List pdfEntries = document.getPdfEntries();
        Assert.assertNotNull((Object)pdfEntries);
        Assert.assertEquals((long)1L, (long)pdfEntries.size());
        Assert.assertTrue((boolean)(pdfEntries.get(0) instanceof PdfDocument.Text));
        PdfDocument.Text entry = (PdfDocument.Text)pdfEntries.get(0);
        Assert.assertEquals((Object)"text1", (Object)entry.getText());
        Assert.assertEquals((long)13L, (long)entry.getX());
        Assert.assertEquals((long)453L, (long)entry.getY());
    }

    @Test
    public void testImage() {
        PdfDocument document = PdfDocument.create((PdfExportPreferences)PdfExportPreferences.create((PdfExportPreferences.Orientation)PdfExportPreferences.Orientation.LANDSCAPE, (PdfExportPreferences.Unit)PdfExportPreferences.Unit.MM, (PdfExportPreferences.Format)PdfExportPreferences.Format.A4));
        document.addImage("data-url1", "jpeg", 13, 453, 345, 234);
        Assert.assertEquals((Object)PdfExportPreferences.Orientation.LANDSCAPE, (Object)document.getSettings().getOrientation());
        Assert.assertEquals((Object)PdfExportPreferences.Unit.MM, (Object)document.getSettings().getUnit());
        Assert.assertEquals((Object)PdfExportPreferences.Format.A4, (Object)document.getSettings().getFormat());
        List pdfEntries = document.getPdfEntries();
        Assert.assertNotNull((Object)pdfEntries);
        Assert.assertEquals((long)1L, (long)pdfEntries.size());
        Assert.assertTrue((boolean)(pdfEntries.get(0) instanceof PdfDocument.Image));
        PdfDocument.Image entry = (PdfDocument.Image)pdfEntries.get(0);
        Assert.assertEquals((Object)"data-url1", (Object)entry.getToDataURL());
        Assert.assertEquals((Object)"jpeg", (Object)entry.getImgType());
        Assert.assertEquals((long)13L, (long)entry.getX());
        Assert.assertEquals((long)453L, (long)entry.getY());
        Assert.assertEquals((long)345L, (long)entry.getWidth());
        Assert.assertEquals((long)234L, (long)entry.getHeight());
    }

    @Test
    public void testCustomSettings() {
        PdfDocument document = PdfDocument.create((PdfExportPreferences)PdfExportPreferences.create((PdfExportPreferences.Orientation)PdfExportPreferences.Orientation.LANDSCAPE, (PdfExportPreferences.Unit)PdfExportPreferences.Unit.IN, (PdfExportPreferences.Format)PdfExportPreferences.Format.B6));
        Assert.assertEquals((Object)PdfExportPreferences.Orientation.LANDSCAPE, (Object)document.getSettings().getOrientation());
        Assert.assertEquals((Object)PdfExportPreferences.Unit.IN, (Object)document.getSettings().getUnit());
        Assert.assertEquals((Object)PdfExportPreferences.Format.B6, (Object)document.getSettings().getFormat());
    }
}

