/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.menu;

import com.google.gwt.core.client.GWT;
import elemental2.dom.DomGlobal;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;

@Dependent
public class DownloadMenuItem {
    private TranslationService translationService;

    @Inject
    public DownloadMenuItem(TranslationService translationService) {
        this.translationService = translationService;
    }

    public MenuItem build(Supplier<Path> pathSupplier) {
        String download = this.translationService.format("DownloadMenuItem.Download", new Object[0]);
        return this.makeMenuItem(download, this.makeMenuItemCommand(pathSupplier));
    }

    Command makeMenuItemCommand(Supplier<Path> pathSupplier) {
        return () -> this.download(pathSupplier);
    }

    void download(Supplier<Path> pathSupplier) {
        String downloadURL = this.getFileDownloadURL(pathSupplier);
        this.open(downloadURL);
    }

    void open(String downloadURL) {
        DomGlobal.window.open((Object)downloadURL);
    }

    MenuItem makeMenuItem(String caption, Command command) {
        return (MenuItem)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)caption).respondsWith(command)).endMenu()).build().getItems().get(0);
    }

    private String getFileDownloadURL(Supplier<Path> pathSupplier) {
        return GWT.getModuleBaseURL() + "defaulteditor/download?path=" + pathSupplier.get().toURI();
    }
}

