/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.menu.common;

import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.RenameInProgressEvent;
import org.uberfire.ext.editor.commons.client.file.CommandWithFileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.FileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.popups.RenamePopUpPresenter;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class SaveAndRenameCommandBuilder<T, M> {
    private final RenamePopUpPresenter renamePopUpPresenter;
    private final BusyIndicatorView busyIndicatorView;
    private final Event<NotificationEvent> notification;
    private final Event<RenameInProgressEvent> renameInProgressEvent;
    private Supplier<Path> pathSupplier;
    private Validator renameValidator;
    private Caller<? extends SupportsSaveAndRename<T, M>> renameCaller;
    private Supplier<M> metadataSupplier = () -> null;
    private Supplier<T> contentSupplier = () -> null;
    private Supplier<Boolean> isDirtySupplier = () -> Boolean.FALSE;
    private Supplier<Boolean> saveValidator = () -> Boolean.TRUE;
    private ParameterizedCommand<Path> onSuccess = path -> {};
    private Command onError = () -> {};

    @Inject
    public SaveAndRenameCommandBuilder(RenamePopUpPresenter renamePopUpPresenter, BusyIndicatorView busyIndicatorView, Event<NotificationEvent> notification, Event<RenameInProgressEvent> renameInProgressEvent) {
        this.renamePopUpPresenter = renamePopUpPresenter;
        this.busyIndicatorView = busyIndicatorView;
        this.notification = notification;
        this.renameInProgressEvent = renameInProgressEvent;
    }

    public SaveAndRenameCommandBuilder<T, M> addValidator(Validator validator) {
        this.renameValidator = validator;
        return this;
    }

    public SaveAndRenameCommandBuilder<T, M> addValidator(Supplier<Boolean> validator) {
        this.saveValidator = validator;
        return this;
    }

    public SaveAndRenameCommandBuilder<T, M> addRenameService(Caller<? extends SupportsSaveAndRename<T, M>> renameCaller) {
        this.renameCaller = renameCaller;
        return this;
    }

    public SaveAndRenameCommandBuilder<T, M> addPathSupplier(Supplier<Path> pathSupplier) {
        this.pathSupplier = pathSupplier;
        return this;
    }

    public SaveAndRenameCommandBuilder<T, M> addMetadataSupplier(Supplier<M> metadataSupplier) {
        this.metadataSupplier = metadataSupplier;
        return this;
    }

    public SaveAndRenameCommandBuilder<T, M> addContentSupplier(Supplier<T> contentSupplier) {
        this.contentSupplier = contentSupplier;
        return this;
    }

    public SaveAndRenameCommandBuilder<T, M> addIsDirtySupplier(Supplier<Boolean> isDirtySupplier) {
        this.isDirtySupplier = isDirtySupplier;
        return this;
    }

    public SaveAndRenameCommandBuilder<T, M> addSuccessCallback(ParameterizedCommand<Path> onSuccess) {
        this.onSuccess = onSuccess;
        return this;
    }

    public SaveAndRenameCommandBuilder<T, M> addErrorCallback(Command onError) {
        this.onError = onError;
        return this;
    }

    public Command build() {
        PortablePreconditions.checkNotNull((String)"pathSupplier", this.pathSupplier);
        PortablePreconditions.checkNotNull((String)"renameValidator", (Object)this.renameValidator);
        PortablePreconditions.checkNotNull((String)"renameCaller", this.renameCaller);
        return () -> {
            CommandWithFileNameAndCommitMessage renameCommand = this.makeRenameCommand();
            CommandWithFileNameAndCommitMessage saveAndRenameCommand = this.makeSaveAndRenameCommand();
            Boolean isValid = this.saveValidator.get();
            if (!isValid.booleanValue()) {
                return;
            }
            this.renamePopUpPresenter.show(this.getPath(), this.renameValidator, this.isDirty(), renameCommand, saveAndRenameCommand);
        };
    }

    CommandWithFileNameAndCommitMessage makeSaveAndRenameCommand() {
        return details -> {
            this.showBusyIndicator();
            this.callSaveAndRename((FileNameAndCommitMessage)details);
        };
    }

    CommandWithFileNameAndCommitMessage makeRenameCommand() {
        return details -> {
            this.showBusyIndicator();
            this.callRename((FileNameAndCommitMessage)details);
        };
    }

    void callSaveAndRename(FileNameAndCommitMessage details) {
        String newFileName = details.getNewFileName();
        String commitMessage = details.getCommitMessage();
        ((SupportsSaveAndRename)this.renameCaller.call(this.onSuccess(), (ErrorCallback)this.onError())).saveAndRename(this.getPath(), newFileName, this.getMetadata(), this.getContent(), commitMessage);
    }

    void callRename(FileNameAndCommitMessage details) {
        String newFileName = details.getNewFileName();
        String commitMessage = details.getCommitMessage();
        ((SupportsSaveAndRename)this.renameCaller.call(this.onSuccess(), (ErrorCallback)this.onError())).rename(this.getPath(), newFileName, commitMessage);
    }

    RemoteCallback<Path> onSuccess() {
        return path -> {
            this.notifyRenameInProgress();
            this.onSuccess.execute(path);
            this.hideRenamePopup();
            this.hideBusyIndicator();
            this.notifyItemRenamedSuccessfully();
        };
    }

    void notifyRenameInProgress() {
        this.renameInProgressEvent.fire((Object)this.makeRenameInProgressEvent());
    }

    RenameInProgressEvent makeRenameInProgressEvent() {
        return new RenameInProgressEvent(this.getPath());
    }

    SaveAndRenameErrorCallback onError() {
        return new SaveAndRenameErrorCallback((HasBusyIndicator)this.busyIndicatorView);
    }

    void notifyItemRenamedSuccessfully() {
        this.notification.fire((Object)this.makeItemRenamedSuccessfullyEvent());
    }

    NotificationEvent makeItemRenamedSuccessfullyEvent() {
        return new NotificationEvent(CommonConstants.INSTANCE.ItemRenamedSuccessfully());
    }

    void hideRenamePopup() {
        this.renamePopUpView().hide();
    }

    void hideBusyIndicator() {
        this.busyIndicatorView.hideBusyIndicator();
    }

    void showBusyIndicator() {
        this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Renaming());
    }

    private RenamePopUpPresenter.View renamePopUpView() {
        return this.renamePopUpPresenter.getView();
    }

    void handleDuplicatedFileName() {
        this.renamePopUpView().handleDuplicatedFileName();
    }

    private boolean fileAlreadyExists(Throwable throwable) {
        return throwable != null && throwable.getMessage() != null && throwable.getMessage().contains("FileAlreadyExistsException");
    }

    Path getPath() {
        return this.pathSupplier.get();
    }

    private Boolean isDirty() {
        return this.isDirtySupplier.get();
    }

    private M getMetadata() {
        return this.metadataSupplier.get();
    }

    private T getContent() {
        return this.contentSupplier.get();
    }

    class SaveAndRenameErrorCallback
    extends HasBusyIndicatorDefaultErrorCallback {
        public SaveAndRenameErrorCallback(HasBusyIndicator view) {
            super(view);
        }

        public boolean error(Message message, Throwable throwable) {
            if (SaveAndRenameCommandBuilder.this.fileAlreadyExists(throwable)) {
                this.hideBusyIndicator();
                SaveAndRenameCommandBuilder.this.handleDuplicatedFileName();
                return false;
            }
            SaveAndRenameCommandBuilder.this.onError.execute();
            SaveAndRenameCommandBuilder.this.hideRenamePopup();
            return this.callSuper(message, throwable);
        }

        boolean callSuper(Message message, Throwable throwable) {
            return super.error(message, throwable);
        }
    }
}

