/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.popups;

import com.google.gwtmockito.WithClassesToStub;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.ext.editor.commons.client.file.RestoreUtil;
import org.uberfire.ext.editor.commons.client.file.popups.RestorePopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.commons.ToggleCommentPresenter;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.editor.commons.version.VersionService;
import org.uberfire.ext.editor.commons.version.events.RestoreEvent;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=MockitoJUnitRunner.class)
@WithClassesToStub(value={CommonConstants.class, ObservablePath.class})
public class RestorePopUpPresenterTest {
    @Mock
    BusyIndicatorView busyIndicatorView;
    @Mock
    Caller<VersionService> versionService;
    @Mock
    EventSourceMock<RestoreEvent> restoreEvent;
    @Mock
    RestoreUtil restoreUtil;
    @Mock
    RestorePopUpPresenter.View view;
    @Mock
    ObservablePath path;
    @Mock
    ParameterizedCommand<String> commandMock;
    @Mock
    ToggleCommentPresenter toggleCommentPresenter;
    RestorePopUpPresenter presenter;

    @Before
    public void init() throws Exception {
        this.presenter = new RestorePopUpPresenter(this.view, this.busyIndicatorView, (Caller)this.versionService, (Event)this.restoreEvent, this.restoreUtil, this.toggleCommentPresenter){};
    }

    @Test
    public void testSetup() throws Exception {
        this.presenter.setup();
        ((RestorePopUpPresenter.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
    }

    @Test
    public void testRestore() throws Exception {
        Mockito.when((Object)this.toggleCommentPresenter.getComment()).thenReturn((Object)"test");
        this.presenter.command = this.commandMock;
        this.presenter.restore();
        ((ParameterizedCommand)Mockito.verify(this.commandMock)).execute((Object)"test");
        ((RestorePopUpPresenter.View)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testShow() throws Exception {
        this.presenter = (RestorePopUpPresenter)Mockito.spy((Object)this.presenter);
        this.presenter.show(this.path, "uri");
        ((RestorePopUpPresenter.View)Mockito.verify((Object)this.view)).show();
        ((RestorePopUpPresenter)Mockito.verify((Object)this.presenter)).restoreCommand(this.path, "uri");
    }

    @Test
    public void testCancel() throws Exception {
        this.presenter.cancel();
        ((RestorePopUpPresenter.View)Mockito.verify((Object)this.view)).hide();
    }
}

