/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.menu;

import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.net.URL;
import java.util.function.Supplier;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.menu.DownloadMenuItemBuilder;
import org.uberfire.mvp.Command;

@WithClassesToStub(value={URL.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class DownloadMenuItemBuilderTest {
    @Mock
    private TranslationService translationService;
    @Mock
    private Path path;
    private Supplier<Path> pathSupplier = () -> this.path;
    private DownloadMenuItemBuilder downloadMenuItemBuilder;

    @Before
    public void setup() {
        this.downloadMenuItemBuilder = (DownloadMenuItemBuilder)Mockito.spy((Object)new DownloadMenuItemBuilder(this.translationService));
    }

    @Test
    public void testBuild() {
        String caption = "Download";
        Command menuItemCommand = () -> {};
        Mockito.when((Object)this.translationService.format("DownloadMenuItem.Download", new Object[0])).thenReturn((Object)"Download");
        ((DownloadMenuItemBuilder)Mockito.doReturn((Object)menuItemCommand).when((Object)this.downloadMenuItemBuilder)).makeMenuItemCommand(this.pathSupplier);
        this.downloadMenuItemBuilder.build(this.pathSupplier);
        ((DownloadMenuItemBuilder)Mockito.verify((Object)this.downloadMenuItemBuilder)).makeMenuItem((String)Matchers.eq((Object)"Download"), (Command)Matchers.eq((Object)menuItemCommand));
    }

    @Test
    public void testMenuItemCommand() {
        Command command = this.downloadMenuItemBuilder.makeMenuItemCommand(this.pathSupplier);
        ((DownloadMenuItemBuilder)Mockito.doNothing().when((Object)this.downloadMenuItemBuilder)).open((String)Matchers.any());
        command.execute();
        ((DownloadMenuItemBuilder)Mockito.verify((Object)this.downloadMenuItemBuilder)).download(this.pathSupplier);
    }

    @Test
    public void testDownload() {
        String expectedDownloadURL = "defaulteditor/download?path=default://master@MySpace/Mortgages/src/main/resources/rule.drl";
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)"default://master@MySpace/Mortgages/src/main/resources/rule.drl");
        ((DownloadMenuItemBuilder)Mockito.doNothing().when((Object)this.downloadMenuItemBuilder)).open((String)Matchers.any());
        this.downloadMenuItemBuilder.download(this.pathSupplier);
        ((DownloadMenuItemBuilder)Mockito.verify((Object)this.downloadMenuItemBuilder)).open((String)Matchers.eq((Object)"defaulteditor/download?path=default://master@MySpace/Mortgages/src/main/resources/rule.drl"));
    }
}

