/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.promise.Promise;
import java.util.Set;
import javax.enterprise.event.Event;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.impl.ObservablePathImpl;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.promise.Promises;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.BaseEditor;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.event.ConcurrentDeleteAcceptedEvent;
import org.uberfire.ext.editor.commons.client.event.ConcurrentDeleteIgnoredEvent;
import org.uberfire.ext.editor.commons.client.event.ConcurrentRenameAcceptedEvent;
import org.uberfire.ext.editor.commons.client.event.ConcurrentRenameIgnoredEvent;
import org.uberfire.ext.editor.commons.client.file.popups.DeletePopUpPresenter;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.file.DefaultMetadata;
import org.uberfire.ext.editor.commons.version.events.RestoreEvent;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.promise.SyncPromises;

@RunWith(value=GwtMockitoTestRunner.class)
public class KieEditorTest {
    private BaseEditor kieEditor;
    private BaseEditorView view;
    private RestoreEvent restoreEvent;
    private ObservablePath observablePath;
    private Promises promises;
    private DeletePopUpPresenter deletePopUpPresenter;

    @Before
    public void setUp() throws Exception {
        this.view = (BaseEditorView)Mockito.mock(BaseEditorView.class);
        this.restoreEvent = (RestoreEvent)Mockito.mock(RestoreEvent.class);
        this.promises = new SyncPromises();
        this.deletePopUpPresenter = (DeletePopUpPresenter)Mockito.mock(DeletePopUpPresenter.class);
        this.kieEditor = (BaseEditor)Mockito.spy((Object)new BaseEditor<String, DefaultMetadata>(this.view){

            protected void loadContent() {
            }

            protected void showVersions() {
            }

            protected Promise<Void> makeMenuBar() {
                return this.promises.resolve();
            }

            protected void showConcurrentUpdatePopup() {
            }

            void disableMenus() {
            }

            public void reload() {
            }
        });
        this.kieEditor.placeManager = (PlaceManager)Mockito.mock(PlaceManager.class);
        this.kieEditor.concurrentRenameIgnoredEvent = (Event)Mockito.spy(new EventMock());
        this.kieEditor.concurrentRenameAcceptedEvent = (Event)Mockito.spy(new EventMock());
        this.kieEditor.concurrentDeleteIgnoredEvent = (Event)Mockito.spy(new EventMock());
        this.kieEditor.concurrentDeleteAcceptedEvent = (Event)Mockito.spy(new EventMock());
        this.kieEditor.versionRecordManager = (VersionRecordManager)Mockito.mock(VersionRecordManager.class);
        this.kieEditor.notification = new EventMock();
        this.kieEditor.promises = this.promises;
        this.kieEditor.deletePopUpPresenter = this.deletePopUpPresenter;
        this.observablePath = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        ClientResourceType resourceType = (ClientResourceType)Mockito.mock(ClientResourceType.class);
        this.kieEditor.init(this.observablePath, placeRequest, resourceType, new MenuItems[0]);
    }

    @Test
    public void testLoad() throws Exception {
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).loadContent();
    }

    @Test
    public void testSimpleSave() throws Exception {
        this.kieEditor.onSave();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).save();
    }

    @Test
    public void testComplicatedSave() throws Exception {
        this.kieEditor.isReadOnly = false;
        Mockito.when((Object)this.kieEditor.versionRecordManager.isCurrentLatest()).thenReturn((Object)true);
        this.kieEditor.onSave();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).save();
    }

    @Test
    public void testSaveReadOnly() throws Exception {
        this.kieEditor.isReadOnly = true;
        Mockito.when((Object)this.kieEditor.versionRecordManager.isCurrentLatest()).thenReturn((Object)true);
        this.kieEditor.onSave();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor, (VerificationMode)Mockito.never())).save();
        ((BaseEditorView)Mockito.verify((Object)this.view)).alertReadOnly();
    }

    @Test
    public void testRestore() throws Exception {
        this.kieEditor.isReadOnly = true;
        Mockito.when((Object)this.kieEditor.versionRecordManager.isCurrentLatest()).thenReturn((Object)false);
        this.kieEditor.onSave();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor, (VerificationMode)Mockito.never())).save();
        ((VersionRecordManager)Mockito.verify((Object)this.kieEditor.versionRecordManager)).restoreToCurrentVersion();
    }

    @Test
    public void testConcurrentSave() throws Exception {
        this.kieEditor.isReadOnly = false;
        Mockito.when((Object)this.kieEditor.versionRecordManager.isCurrentLatest()).thenReturn((Object)true);
        this.kieEditor.concurrentUpdateSessionInfo = new ObservablePath.OnConcurrentUpdateEvent(){

            public Path getPath() {
                return null;
            }

            public String getId() {
                return null;
            }

            public User getIdentity() {
                return null;
            }
        };
        this.kieEditor.onSave();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor, (VerificationMode)Mockito.never())).save();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).showConcurrentUpdatePopup();
    }

    @Test
    public void testInitResetsConcurrentSessionInfo() throws Exception {
        this.kieEditor.isReadOnly = false;
        Mockito.when((Object)this.kieEditor.versionRecordManager.isCurrentLatest()).thenReturn((Object)true);
        this.kieEditor.concurrentUpdateSessionInfo = new ObservablePath.OnConcurrentUpdateEvent(){

            public Path getPath() {
                return null;
            }

            public String getId() {
                return null;
            }

            public User getIdentity() {
                return null;
            }
        };
        Set menuItems = this.kieEditor.menuItems;
        this.kieEditor.init((ObservablePath)new ObservablePathImpl(), this.kieEditor.place, this.kieEditor.type, menuItems.toArray(new MenuItems[0]));
        this.kieEditor.onSave();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor, (VerificationMode)Mockito.never())).showConcurrentUpdatePopup();
    }

    @Test
    public void onRestoreShouldInitBaseEditorSuccessfully() throws Exception {
        Mockito.when((Object)this.kieEditor.versionRecordManager.getCurrentPath()).thenReturn((Object)this.observablePath);
        Mockito.when((Object)this.restoreEvent.getPath()).thenReturn((Object)this.observablePath);
        this.kieEditor.onRestore(this.restoreEvent);
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).onRestore(this.restoreEvent);
        ((VersionRecordManager)Mockito.verify((Object)this.kieEditor.versionRecordManager)).getPathToLatest();
    }

    @Test
    public void onRestoreWithNullCurrentPathShouldNotInitEditor() throws Exception {
        Mockito.when((Object)this.kieEditor.versionRecordManager.getCurrentPath()).thenReturn(null);
        this.kieEditor.onRestore(this.restoreEvent);
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).onRestore(this.restoreEvent);
        ((VersionRecordManager)Mockito.verify((Object)this.kieEditor.versionRecordManager, (VerificationMode)Mockito.never())).getPathToLatest();
    }

    @Test
    public void onRestoreWithNullRestoreEventPathShouldNotInitEditor() throws Exception {
        Mockito.when((Object)this.restoreEvent.getPath()).thenReturn(null);
        this.kieEditor.onRestore(this.restoreEvent);
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).onRestore(this.restoreEvent);
        ((VersionRecordManager)Mockito.verify((Object)this.kieEditor.versionRecordManager, (VerificationMode)Mockito.never())).getPathToLatest();
    }

    @Test
    public void onRestoreWithNullRestoreEventShouldNotInitEditor() throws Exception {
        this.kieEditor.onRestore(null);
        Mockito.when((Object)this.kieEditor.versionRecordManager.getPathToLatest()).thenReturn((Object)new ObservablePathImpl());
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).onRestore((RestoreEvent)Matchers.any());
        ((VersionRecordManager)Mockito.verify((Object)this.kieEditor.versionRecordManager, (VerificationMode)Mockito.never())).getPathToLatest();
    }

    @Test
    public void testOnValidateMethodIsCalled() throws Exception {
        this.kieEditor.onValidate((Command)Mockito.mock(Command.class));
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).onValidate((Command)Matchers.any(Command.class));
    }

    @Test
    public void testOnConcurrentRenameIgnoreCommand() {
        Command onConcurrentRenameIgnoreCommand = this.kieEditor.onConcurrentRenameIgnoreCommand(this.observablePath);
        onConcurrentRenameIgnoreCommand.execute();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).disableMenus();
        ((Event)Mockito.verify((Object)this.kieEditor.concurrentRenameIgnoredEvent)).fire(Matchers.eq((Object)new ConcurrentRenameIgnoredEvent(this.observablePath)));
    }

    @Test
    public void testOnConcurrentRenameAcceptedCommand() {
        Command onConcurrentRenameCloseCommand = this.kieEditor.onConcurrentRenameCloseCommand(this.observablePath);
        onConcurrentRenameCloseCommand.execute();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).reload();
        ((Event)Mockito.verify((Object)this.kieEditor.concurrentRenameAcceptedEvent)).fire(Matchers.eq((Object)new ConcurrentRenameAcceptedEvent(this.observablePath)));
    }

    @Test
    public void testOnConcurrentDeleteIgnoreCommand() {
        this.testOnConcurrentDeleteIgnoreCommand(false);
    }

    @Test
    public void testOnConcurrentDeleteIgnoreCommandDeletePopupOpened() {
        this.testOnConcurrentDeleteIgnoreCommand(true);
    }

    private void testOnConcurrentDeleteIgnoreCommand(boolean isDeletePopupOpened) {
        Mockito.when((Object)this.deletePopUpPresenter.isOpened()).thenReturn((Object)isDeletePopupOpened);
        Command onConcurrentDeleteIgnoreCommand = this.kieEditor.onConcurrentDeleteIgnoreCommand(this.observablePath);
        onConcurrentDeleteIgnoreCommand.execute();
        ((BaseEditor)Mockito.verify((Object)this.kieEditor)).disableMenus();
        ((Event)Mockito.verify((Object)this.kieEditor.concurrentDeleteIgnoredEvent)).fire(Matchers.eq((Object)new ConcurrentDeleteIgnoredEvent(this.observablePath)));
        ((DeletePopUpPresenter)Mockito.verify((Object)this.deletePopUpPresenter, (VerificationMode)(isDeletePopupOpened ? Mockito.times((int)1) : Mockito.never()))).cancel();
    }

    @Test
    public void testOnConcurrentDeleteAcceptedCommand() {
        this.testOnConcurrentDeleteAcceptedCommand(false);
    }

    @Test
    public void testOnConcurrentDeleteAcceptedCommandDeletePopupOpened() {
        this.testOnConcurrentDeleteAcceptedCommand(true);
    }

    private void testOnConcurrentDeleteAcceptedCommand(boolean isDeletePopupOpened) {
        Mockito.when((Object)this.deletePopUpPresenter.isOpened()).thenReturn((Object)isDeletePopupOpened);
        Command onConcurrentDeleteCloseCommand = this.kieEditor.onConcurrentDeleteCloseCommand(this.observablePath);
        onConcurrentDeleteCloseCommand.execute();
        ((PlaceManager)Mockito.verify((Object)this.kieEditor.placeManager)).closePlace((PlaceRequest)Matchers.any(PlaceRequest.class));
        ((Event)Mockito.verify((Object)this.kieEditor.concurrentDeleteAcceptedEvent)).fire(Matchers.eq((Object)new ConcurrentDeleteAcceptedEvent(this.observablePath)));
        ((DeletePopUpPresenter)Mockito.verify((Object)this.deletePopUpPresenter, (VerificationMode)(isDeletePopupOpened ? Mockito.times((int)1) : Mockito.never()))).cancel();
    }

    public static class EventMock<T>
    extends EventSourceMock<T> {
        public void fire(T event) {
        }
    }
}

