/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.popups;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.editor.commons.client.file.CommandWithFileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.FileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.popups.commons.ToggleCommentPresenter;
import org.uberfire.ext.editor.commons.client.validation.ValidationErrorReason;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;

@Dependent
public class RenamePopUpPresenter {
    private String originalFileName;
    private Path path;
    private Validator validator;
    private CommandWithFileNameAndCommitMessage command;
    private ToggleCommentPresenter toggleCommentPresenter;
    private View view;

    @Inject
    public RenamePopUpPresenter(View view, ToggleCommentPresenter toggleCommentPresenter) {
        this.view = view;
        this.toggleCommentPresenter = toggleCommentPresenter;
    }

    public void show(Path path, Validator validator, CommandWithFileNameAndCommitMessage command, String originalFileName) {
        this.validator = (Validator)PortablePreconditions.checkNotNull((String)"validator", (Object)validator);
        this.path = (Path)PortablePreconditions.checkNotNull((String)"path", (Object)path);
        this.command = (CommandWithFileNameAndCommitMessage)PortablePreconditions.checkNotNull((String)"command", (Object)command);
        this.originalFileName = originalFileName;
        this.view.setOriginalFileName(originalFileName);
        this.view.show();
    }

    public void show(Path path, CommandWithFileNameAndCommitMessage copyPopupCommand, String originalFileName) {
        this.show(path, this.defaultValidator(), copyPopupCommand, originalFileName);
    }

    public void show(Path path, Validator validator, CommandWithFileNameAndCommitMessage command) {
        this.show(path, validator, command, "");
    }

    public void show(Path path, CommandWithFileNameAndCommitMessage renamePopupCommand) {
        this.show(path, this.defaultValidator(), renamePopupCommand, "");
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void rename(String newName) {
        String extension = this.extension(this.path.getFileName());
        String fileName = newName + extension;
        this.validator.validate(fileName, this.validatorCallback(this.toggleCommentPresenter.getComment(), newName));
    }

    private String extension(String fileName) {
        return fileName.lastIndexOf(".") > 0 ? fileName.substring(fileName.lastIndexOf(".")) : "";
    }

    private ValidatorWithReasonCallback validatorCallback(final String comment, final String baseFileName) {
        return new ValidatorWithReasonCallback(){

            @Override
            public void onFailure(String reason) {
                if (ValidationErrorReason.DUPLICATED_NAME.name().equals(reason)) {
                    RenamePopUpPresenter.this.view.handleDuplicatedFileName();
                } else if (ValidationErrorReason.NOT_ALLOWED.name().equals(reason)) {
                    RenamePopUpPresenter.this.view.handleRenameNotAllowed();
                } else {
                    RenamePopUpPresenter.this.view.handleInvalidFileName();
                }
            }

            @Override
            public void onSuccess() {
                RenamePopUpPresenter.this.command.execute(new FileNameAndCommitMessage(baseFileName, comment));
            }

            @Override
            public void onFailure() {
                RenamePopUpPresenter.this.view.handleInvalidFileName();
            }
        };
    }

    public void cancel() {
        this.view.hide();
    }

    public View getView() {
        return this.view;
    }

    public ToggleCommentPresenter getToggleCommentPresenter() {
        return this.toggleCommentPresenter;
    }

    private Validator defaultValidator() {
        return new Validator(){

            @Override
            public void validate(String value, ValidatorCallback callback) {
                callback.onSuccess();
            }
        };
    }

    Path getPath() {
        return this.path;
    }

    Validator getValidator() {
        return this.validator;
    }

    CommandWithFileNameAndCommitMessage getCommand() {
        return this.command;
    }

    public static interface View
    extends UberElement<RenamePopUpPresenter> {
        public void show();

        public void hide();

        public void handleDuplicatedFileName();

        public void handleInvalidFileName();

        public void setOriginalFileName(String var1);

        public void handleRenameNotAllowed();
    }
}

