/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.popups;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.editor.commons.client.file.popups.CommonModalBuilder;
import org.uberfire.ext.editor.commons.client.file.popups.RenamePopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.commons.ToggleCommentPresenter;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class RenamePopUpView
implements RenamePopUpPresenter.View,
IsElement {
    @Inject
    @DataField(value="body")
    Div body;
    @Inject
    @DataField(value="newNameTextBox")
    TextBox newNameTextBox;
    @Inject
    @DataField(value="error")
    Div error;
    @Inject
    @DataField(value="errorMessage")
    Span errorMessage;
    @Inject
    private TranslationService translationService;
    private RenamePopUpPresenter presenter;
    private BaseModal modal;
    private Button renameButton;
    private String originalFileName;

    public void init(RenamePopUpPresenter presenter) {
        this.presenter = presenter;
        this.modalSetup();
    }

    @Override
    public void show() {
        this.errorSetup();
        this.setupComment();
        this.newNameTextBoxSetup();
        this.modal.show();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    @Override
    public void handleDuplicatedFileName() {
        this.showError(this.translate("RenamePopUpView.FileAlreadyExists", this.newNameTextBox.getValue()));
    }

    @Override
    public void handleInvalidFileName() {
        this.showError(this.translate("RenamePopUpView.InvalidFileName", this.newNameTextBox.getValue()));
    }

    @Override
    public void setOriginalFileName(String fileName) {
        this.originalFileName = fileName;
    }

    @Override
    public void handleRenameNotAllowed() {
        this.showError(this.translate("RenamePopUpView.RenameNotAllowed", new Object[0]));
    }

    @EventHandler(value={"newNameTextBox"})
    public void onNewFileNameChange(KeyUpEvent event) {
        this.disableRenameButtonIfNewNameIsNotNew();
    }

    private void modalSetup() {
        this.modal = new CommonModalBuilder().addHeader(this.translate("RenamePopUpView.RenameAsset", new Object[0])).addBody((HTMLElement)this.body).addFooter(this.footer()).build();
    }

    private ModalFooter footer() {
        GenericModalFooter footer = new GenericModalFooter();
        footer.add((Widget)this.cancelButton());
        footer.add((Widget)this.renameButton());
        return footer;
    }

    private Button renameButton() {
        this.renameButton = this.button(this.translate("RenamePopUpView.Rename", new Object[0]), this.renameCommand(), ButtonType.PRIMARY);
        return this.renameButton;
    }

    private Button cancelButton() {
        return this.button(this.translate("RenamePopUpView.Cancel", new Object[0]), this.cancelCommand(), ButtonType.DEFAULT);
    }

    private Button button(String text, final Command command, ButtonType type) {
        Button button = new Button(text, new ClickHandler(){

            public void onClick(ClickEvent event) {
                command.execute();
            }
        });
        button.setType(type);
        return button;
    }

    private String translate(String key, Object ... args) {
        return this.translationService.format(key, args);
    }

    private void newNameTextBoxSetup() {
        this.newNameTextBox.setValue((Object)this.originalFileName);
        this.disableRenameButtonIfNewNameIsNotNew();
    }

    private void errorSetup() {
        this.error.setHidden(true);
    }

    private void disableRenameButtonIfNewNameIsNotNew() {
        this.renameButton.setEnabled(!this.newNameTextBox.getValue().equals(this.originalFileName));
    }

    private void showError(String errorMessage) {
        this.errorMessage.setTextContent(errorMessage);
        this.error.setHidden(false);
    }

    private Command renameCommand() {
        return () -> this.presenter.rename(this.newNameTextBox.getValue());
    }

    private Command cancelCommand() {
        return () -> this.presenter.cancel();
    }

    private void setupComment() {
        this.body.appendChild((Node)this.toggleCommentPresenter().getViewElement());
    }

    private ToggleCommentPresenter toggleCommentPresenter() {
        return this.presenter.getToggleCommentPresenter();
    }
}

