/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Supplier;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.BaseEditor;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.client.menu.common.SaveAndRenameCommandBuilder;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.file.DefaultMetadata;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class BaseEditorTest {
    private String fakeContent = "fakeContent";
    @Mock
    private VersionRecordManager versionRecordManager;
    @Mock
    private BaseEditorView baseView;
    @Mock
    private BasicFileMenuBuilder menuBuilder;
    private SaveAndRenameCommandBuilder<String, DefaultMetadata> builder = (SaveAndRenameCommandBuilder)Mockito.spy(this.makeBuilder());
    @InjectMocks
    private BaseEditor<String, DefaultMetadata> editor = (BaseEditor)Mockito.spy(this.makeBaseEditor());

    @Test
    public void testSaveAndRename() {
        Supplier pathSupplier = (Supplier)Mockito.mock(Supplier.class);
        Validator renameValidator = (Validator)Mockito.mock(Validator.class);
        Supplier saveValidator = (Supplier)Mockito.mock(Supplier.class);
        Caller supportsSaveAndRename = (Caller)Mockito.mock(Caller.class);
        Supplier metadataSupplier = (Supplier)Mockito.mock(Supplier.class);
        Supplier contentSupplier = (Supplier)Mockito.mock(Supplier.class);
        Supplier isDirtySupplier = (Supplier)Mockito.mock(Supplier.class);
        ParameterizedCommand parameterizedCommand = (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class);
        Command command = (Command)Mockito.mock(Command.class);
        ((BaseEditor)Mockito.doReturn((Object)pathSupplier).when(this.editor)).getPathSupplier();
        ((BaseEditor)Mockito.doReturn((Object)renameValidator).when(this.editor)).getRenameValidator();
        ((BaseEditor)Mockito.doReturn((Object)saveValidator).when(this.editor)).getSaveValidator();
        ((BaseEditor)Mockito.doReturn((Object)supportsSaveAndRename).when(this.editor)).getSaveAndRenameServiceCaller();
        ((BaseEditor)Mockito.doReturn((Object)metadataSupplier).when(this.editor)).getMetadataSupplier();
        ((BaseEditor)Mockito.doReturn((Object)contentSupplier).when(this.editor)).getContentSupplier();
        ((BaseEditor)Mockito.doReturn((Object)isDirtySupplier).when(this.editor)).isDirtySupplier();
        ((BaseEditor)Mockito.doReturn((Object)parameterizedCommand).when(this.editor)).onSuccess();
        ((SaveAndRenameCommandBuilder)Mockito.doReturn((Object)command).when(this.builder)).build();
        Command saveAndRenameCommand = this.editor.getSaveAndRename();
        Assert.assertEquals((Object)command, (Object)saveAndRenameCommand);
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder)).addPathSupplier(pathSupplier);
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder)).addValidator(renameValidator);
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder)).addValidator(saveValidator);
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder)).addRenameService(supportsSaveAndRename);
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder)).addMetadataSupplier(metadataSupplier);
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder)).addContentSupplier(contentSupplier);
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder)).addIsDirtySupplier(isDirtySupplier);
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder)).addSuccessCallback(parameterizedCommand);
    }

    @Test
    public void testGetPathSupplier() {
        ObservablePath observablePath = (ObservablePath)Mockito.mock(ObservablePath.class);
        ((VersionRecordManager)Mockito.doReturn((Object)observablePath).when((Object)this.versionRecordManager)).getPathToLatest();
        Supplier pathSupplier = this.editor.getPathSupplier();
        Assert.assertEquals((Object)observablePath, pathSupplier.get());
    }

    @Test
    public void testGetContentSupplier() {
        Supplier contentSupplier = this.editor.getContentSupplier();
        String content = (String)contentSupplier.get();
        Assert.assertEquals((Object)this.fakeContent, (Object)content);
    }

    @Test
    public void testGetMetadataSupplier() {
        Assert.assertNull(this.editor.getMetadataSupplier().get());
    }

    @Test
    public void testGetSaveAndRenameServiceCaller() {
        Assert.assertNull((Object)this.editor.getSaveAndRenameServiceCaller());
    }

    @Test
    public void testIsContentDirtyWhenEditorIsDirty() {
        ((BaseEditor)Mockito.doReturn((Object)true).when(this.editor)).isDirty(Integer.valueOf(this.fakeContent.hashCode()));
        Assert.assertTrue((boolean)this.editor.isContentDirty());
    }

    @Test
    public void testIsContentDirtyWhenEditorIsNotDirty() {
        ((BaseEditor)Mockito.doReturn((Object)false).when(this.editor)).isDirty(Integer.valueOf(this.fakeContent.hashCode()));
        Assert.assertFalse((boolean)this.editor.isContentDirty());
    }

    @Test
    public void testIsContentDirtyWhenGetContentRaisesAnException() {
        ((BaseEditor)Mockito.doReturn(null).when(this.editor)).getContentSupplier();
        Assert.assertFalse((boolean)this.editor.isContentDirty());
    }

    @Test
    public void testIsMetadataDirtyWhenMetadataIsDirty() {
        DefaultMetadata metadata = this.fakeMetadata(123);
        Supplier<DefaultMetadata> metadataSupplier = () -> metadata;
        ((BaseEditor)Mockito.doReturn(metadataSupplier).when(this.editor)).getMetadataSupplier();
        this.editor.metadataOriginalHash = 456;
        Assert.assertTrue((boolean)this.editor.isMetadataDirty());
    }

    @Test
    public void testIsMetadataDirtyWhenMetadataIsNotDirty() {
        DefaultMetadata metadata = this.fakeMetadata(123);
        Supplier<DefaultMetadata> metadataSupplier = () -> metadata;
        ((BaseEditor)Mockito.doReturn(metadataSupplier).when(this.editor)).getMetadataSupplier();
        this.editor.metadataOriginalHash = 123;
        Assert.assertFalse((boolean)this.editor.isMetadataDirty());
    }

    @Test
    public void testIsMetadataDirtyWhenMetadataIsNull() {
        Assert.assertFalse((boolean)this.editor.isMetadataDirty());
    }

    @Test
    public void testIsDirtySupplierWhenContentIsDirty() {
        ((BaseEditor)Mockito.doReturn((Object)true).when(this.editor)).isContentDirty();
        ((BaseEditor)Mockito.doReturn((Object)false).when(this.editor)).isMetadataDirty();
        Assert.assertTrue((boolean)((Boolean)this.editor.isDirtySupplier().get()));
    }

    @Test
    public void testIsDirtySupplierWhenMetadataIsDirty() {
        ((BaseEditor)Mockito.doReturn((Object)false).when(this.editor)).isContentDirty();
        ((BaseEditor)Mockito.doReturn((Object)true).when(this.editor)).isMetadataDirty();
        Assert.assertTrue((boolean)((Boolean)this.editor.isDirtySupplier().get()));
    }

    @Test
    public void testIsDirtySupplierWhenContentAndMetdataAreDirty() {
        ((BaseEditor)Mockito.doReturn((Object)true).when(this.editor)).isContentDirty();
        ((BaseEditor)Mockito.doReturn((Object)true).when(this.editor)).isMetadataDirty();
        Assert.assertTrue((boolean)((Boolean)this.editor.isDirtySupplier().get()));
    }

    @Test
    public void testIsDirtySupplierWhenContentAndMetdataAreNotDirty() {
        ((BaseEditor)Mockito.doReturn((Object)false).when(this.editor)).isContentDirty();
        ((BaseEditor)Mockito.doReturn((Object)false).when(this.editor)).isMetadataDirty();
        Assert.assertFalse((boolean)((Boolean)this.editor.isDirtySupplier().get()));
    }

    @Test
    public void testGetSaveValidatorWhenItIsReadOnlyAndItIsCurrentLatest() {
        this.editor.isReadOnly = true;
        ((VersionRecordManager)Mockito.doReturn((Object)true).when((Object)this.versionRecordManager)).isCurrentLatest();
        boolean success = (Boolean)this.editor.getSaveValidator().get();
        ((BaseEditorView)Mockito.verify((Object)this.baseView)).alertReadOnly();
        Assert.assertFalse((boolean)success);
    }

    @Test
    public void testGetSaveValidatorWhenItIsReadOnlyAndItIsNotCurrentLatest() {
        this.editor.isReadOnly = true;
        ((VersionRecordManager)Mockito.doReturn((Object)false).when((Object)this.versionRecordManager)).isCurrentLatest();
        boolean success = (Boolean)this.editor.getSaveValidator().get();
        ((VersionRecordManager)Mockito.verify((Object)this.versionRecordManager)).restoreToCurrentVersion();
        Assert.assertFalse((boolean)success);
    }

    @Test
    public void testGetSaveValidatorWhenConcurrentUpdateSessionInfoIsNotNull() {
        this.editor.isReadOnly = false;
        this.editor.concurrentUpdateSessionInfo = (ObservablePath.OnConcurrentUpdateEvent)Mockito.mock(ObservablePath.OnConcurrentUpdateEvent.class);
        ((BaseEditor)Mockito.doNothing().when(this.editor)).showConcurrentUpdatePopup();
        boolean success = (Boolean)this.editor.getSaveValidator().get();
        ((BaseEditor)Mockito.verify(this.editor)).showConcurrentUpdatePopup();
        Assert.assertFalse((boolean)success);
    }

    @Test
    public void testGetSaveValidatorWhenConcurrentUpdateSessionInfoIsNull() {
        this.editor.isReadOnly = false;
        this.editor.concurrentUpdateSessionInfo = null;
        boolean success = (Boolean)this.editor.getSaveValidator().get();
        Assert.assertTrue((boolean)success);
    }

    @Test
    public void testOnSuccess() {
        Path path = (Path)Mockito.mock(Path.class);
        String content = "content";
        int contentHash = "content".hashCode();
        int metadataHash = 456;
        Supplier<String> contentSupplier = () -> "content";
        Supplier<DefaultMetadata> metadataSupplier = () -> this.fakeMetadata(456);
        ((BaseEditor)Mockito.doReturn(contentSupplier).when(this.editor)).getContentSupplier();
        ((BaseEditor)Mockito.doReturn(metadataSupplier).when(this.editor)).getMetadataSupplier();
        this.editor.onSuccess().execute((Object)path);
        ((BaseEditor)Mockito.verify(this.editor)).setOriginalHash(Integer.valueOf(contentHash));
        ((BaseEditor)Mockito.verify(this.editor)).setMetadataOriginalHash(Integer.valueOf(456));
    }

    @Test
    public void testOnSuccessShouldNotCallMetadataHashIfNotAvailable() {
        Path path = (Path)Mockito.mock(Path.class);
        String content = "dora";
        int contentHash = "dora".hashCode();
        int metadataHash = 456;
        Supplier<String> contentSupplier = () -> "dora";
        Supplier<DefaultMetadata> metadataSupplier = () -> null;
        ((BaseEditor)Mockito.doReturn(contentSupplier).when(this.editor)).getContentSupplier();
        ((BaseEditor)Mockito.doReturn(metadataSupplier).when(this.editor)).getMetadataSupplier();
        this.editor.onSuccess().execute((Object)path);
        ((BaseEditor)Mockito.verify(this.editor)).setOriginalHash(Integer.valueOf(contentHash));
        ((BaseEditor)Mockito.verify(this.editor, (VerificationMode)Mockito.never())).setMetadataOriginalHash(Integer.valueOf(456));
    }

    @Test
    public void testMakeMenuBarWhenItContainsAllMenuItems() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        MenuItem menuItem = (MenuItem)Mockito.mock(MenuItem.class);
        Command onValidate = (Command)Mockito.mock(Command.class);
        Command onSave = (Command)Mockito.mock(Command.class);
        Command saveAndRename = (Command)Mockito.mock(Command.class);
        Validator validator = (Validator)Mockito.mock(Validator.class);
        Validator copyValidator = (Validator)Mockito.mock(Validator.class);
        Caller copyServiceCaller = (Caller)Mockito.mock(Caller.class);
        Caller deleteServiceCaller = (Caller)Mockito.mock(Caller.class);
        this.editor.menuItems = new HashSet<MenuItems>(Arrays.asList(MenuItems.SAVE, MenuItems.COPY, MenuItems.RENAME, MenuItems.DELETE, MenuItems.VALIDATE, MenuItems.HISTORY));
        ((VersionRecordManager)Mockito.doReturn((Object)path).when((Object)this.versionRecordManager)).getCurrentPath();
        ((VersionRecordManager)Mockito.doReturn((Object)menuItem).when((Object)this.versionRecordManager)).buildMenu();
        ((BaseEditor)Mockito.doReturn((Object)onValidate).when(this.editor)).onValidate();
        ((BaseEditor)Mockito.doReturn((Object)onSave).when(this.editor)).getOnSave();
        ((BaseEditor)Mockito.doReturn((Object)saveAndRename).when(this.editor)).getSaveAndRename();
        ((BaseEditor)Mockito.doReturn((Object)validator).when(this.editor)).getCopyValidator();
        ((BaseEditor)Mockito.doReturn((Object)copyValidator).when(this.editor)).getCopyValidator();
        ((BaseEditor)Mockito.doReturn((Object)copyServiceCaller).when(this.editor)).getCopyServiceCaller();
        ((BaseEditor)Mockito.doReturn((Object)deleteServiceCaller).when(this.editor)).getDeleteServiceCaller();
        this.editor.makeMenuBar();
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addSave(onSave);
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addCopy((Path)path, copyValidator, copyServiceCaller);
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addRename(saveAndRename);
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addDelete((Path)path, deleteServiceCaller);
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addValidate(onValidate);
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addNewTopLevelMenu(menuItem);
    }

    @Test
    public void testMakeMenuBarWhenItDoesNotContainAllMenuItems() {
        this.editor.menuItems = new HashSet();
        this.editor.makeMenuBar();
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder, (VerificationMode)Mockito.never())).addSave((Command)Matchers.any(Command.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder, (VerificationMode)Mockito.never())).addCopy((Path)Matchers.any(ObservablePath.class), (Validator)Matchers.any(Validator.class), (Caller)Matchers.any(Caller.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder, (VerificationMode)Mockito.never())).addRename((Command)Matchers.any());
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder, (VerificationMode)Mockito.never())).addDelete((Path)Matchers.any(ObservablePath.class), (Caller)Matchers.any(Caller.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder, (VerificationMode)Mockito.never())).addValidate((Command)Matchers.any());
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder, (VerificationMode)Mockito.never())).addNewTopLevelMenu((MenuItem)Matchers.any());
    }

    private DefaultMetadata fakeMetadata(final int hashCode) {
        return new DefaultMetadata(){

            public int hashCode() {
                return hashCode;
            }
        };
    }

    private SaveAndRenameCommandBuilder<String, DefaultMetadata> makeBuilder() {
        return new SaveAndRenameCommandBuilder(null, null, null);
    }

    private BaseEditor<String, DefaultMetadata> makeBaseEditor() {
        return new BaseEditor<String, DefaultMetadata>(){

            protected SaveAndRenameCommandBuilder<String, DefaultMetadata> getSaveAndRenameCommandBuilder() {
                return BaseEditorTest.this.builder;
            }

            protected void loadContent() {
            }

            protected Supplier<String> getContentSupplier() {
                return () -> BaseEditorTest.this.fakeContent;
            }
        };
    }
}

