/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.exports;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.editor.commons.client.file.exports.PdfDocument;
import org.uberfire.ext.editor.commons.client.file.exports.PdfFileExport;
import org.uberfire.ext.editor.commons.client.file.exports.jso.JsPdf;
import org.uberfire.ext.editor.commons.file.exports.PdfExportPreferences;

@RunWith(value=GwtMockitoTestRunner.class)
public class PdfFileExportTest {
    private PdfFileExport tested;
    private PdfDocument content;
    @Mock
    private JsPdf fileExport;

    @Before
    public void setup() {
        this.content = PdfDocument.create((PdfExportPreferences)PdfExportPreferences.create((PdfExportPreferences.Orientation)PdfExportPreferences.Orientation.PORTRAIT, (PdfExportPreferences.Unit)PdfExportPreferences.Unit.MM, (PdfExportPreferences.Format)PdfExportPreferences.Format.A4));
        this.tested = new PdfFileExport();
    }

    @Test
    public void saveAsTextTest() {
        this.content.addText("test", 10, 20);
        this.tested.export(this.content, "file1", this.fileExport);
        ((JsPdf)Mockito.verify((Object)this.fileExport, (VerificationMode)Mockito.times((int)1))).text((String)Mockito.eq((Object)"test"), Mockito.eq((int)10), Mockito.eq((int)20));
        ((JsPdf)Mockito.verify((Object)this.fileExport)).save((String)Mockito.eq((Object)"file1"));
    }

    @Test
    public void saveAsImageTest() {
        String dataUrl = "data:image/jpeg;base64,9j/4AAQSkZJRgABAQEASABIAAD";
        this.content.addImage("data:image/jpeg;base64,9j/4AAQSkZJRgABAQEASABIAAD", "jpeg", 10, 20, 100, 200);
        this.tested.export(this.content, "file2", this.fileExport);
        ((JsPdf)Mockito.verify((Object)this.fileExport, (VerificationMode)Mockito.times((int)1))).addImage((String)Mockito.eq((Object)"data:image/jpeg;base64,9j/4AAQSkZJRgABAQEASABIAAD"), (String)Mockito.eq((Object)"jpeg"), Mockito.eq((int)10), Mockito.eq((int)20), Mockito.eq((int)100), Mockito.eq((int)200));
        ((JsPdf)Mockito.verify((Object)this.fileExport)).save((String)Mockito.eq((Object)"file2"));
    }
}

