/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.editor.commons.client.BaseEditor;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class BaseEditorValidationTest {
    @Mock
    protected BaseEditorView baseView;
    private BaseEditor baseEditor;

    @Test
    public void showAndHide() throws Exception {
        this.baseEditor = new BaseEditor(){

            protected void loadContent() {
            }

            protected void onValidate(Command finished) {
                finished.execute();
            }
        };
        this.baseEditor.baseView = this.baseView;
        this.baseEditor.getValidateCommand().execute();
        ((BaseEditorView)Mockito.verify((Object)this.baseView)).showBusyIndicator("Validating");
        ((BaseEditorView)Mockito.verify((Object)this.baseView)).hideBusyIndicator();
    }

    @Test
    public void preventRerun() throws Exception {
        this.baseEditor = new BaseEditor(){

            protected void loadContent() {
            }

            protected void onValidate(Command finished) {
            }
        };
        this.baseEditor.baseView = this.baseView;
        this.baseEditor.getValidateCommand().execute();
        ((BaseEditorView)Mockito.verify((Object)this.baseView)).showBusyIndicator("Validating");
        ((BaseEditorView)Mockito.verify((Object)this.baseView, (VerificationMode)Mockito.never())).hideBusyIndicator();
        Mockito.reset((Object[])new BaseEditorView[]{this.baseView});
        this.baseEditor.getValidateCommand().execute();
        ((BaseEditorView)Mockito.verify((Object)this.baseView, (VerificationMode)Mockito.never())).showBusyIndicator("Validating");
        ((BaseEditorView)Mockito.verify((Object)this.baseView, (VerificationMode)Mockito.never())).hideBusyIndicator();
    }
}

