/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.promise.Promises;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.BaseEditor;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.file.RestoreUtil;
import org.uberfire.ext.editor.commons.client.history.VersionMenuDropDownButton;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.client.menu.common.SaveAndRenameCommandBuilder;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.ext.editor.commons.version.VersionService;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.promise.SyncPromises;

@RunWith(value=GwtMockitoTestRunner.class)
public class BaseEditorRenameTest {
    private static VersionMenuDropDownButton versionMenuDropDownButton;
    private CallerMock<VersionService> versionServiceCaller;
    private static BaseEditor baseEditor;
    @Mock
    private static VersionRecordManager versionRecordManager;
    @Mock
    private RestoreUtil restoreUtil;
    @Mock
    private PlaceRequest placeRequest;
    @Mock
    private ClientResourceType clientResourceType;
    @Mock
    private BaseEditorView baseView;
    @Mock
    private VersionService versionService;
    @Mock
    private BasicFileMenuBuilder menuBuilder;
    @Mock
    private EventSourceMock<ChangeTitleWidgetEvent> changeTitleNotification = new EventSourceMock();
    @Mock
    private ObservablePath observablePath;
    private Promises promises;

    @Before
    public void setup() {
        this.promises = new SyncPromises();
        versionMenuDropDownButton = new VersionMenuDropDownButton();
        this.versionServiceCaller = new CallerMock((Object)this.versionService);
        baseEditor = new BaseEditor(versionRecordManager, this.baseView, this.menuBuilder, (Event)this.changeTitleNotification){
            {
                this.promises = BaseEditorRenameTest.this.promises;
            }

            protected void loadContent() {
            }

            protected SaveAndRenameCommandBuilder getSaveAndRenameCommandBuilder() {
                return new SaveAndRenameCommandBuilder(null, null, null, null);
            }

            public Validator getRenameValidator() {
                return (Validator)Mockito.mock(Validator.class);
            }

            protected Caller<? extends SupportsSaveAndRename> getSaveAndRenameServiceCaller() {
                return (Caller)Mockito.mock(Caller.class);
            }
        };
        Mockito.when((Object)this.restoreUtil.createObservablePath((Path)Matchers.any(), (String)Matchers.any())).thenReturn((Object)this.observablePath);
        baseEditor.init(this.observablePath, this.placeRequest, this.clientResourceType, true, true, new MenuItems[]{MenuItems.SAVE, MenuItems.DELETE, MenuItems.RENAME, MenuItems.COPY, MenuItems.HISTORY});
    }

    @Test
    public void testVersionRecordManagerIsInitializedOnRename() {
        Mockito.reset((Object[])new VersionRecordManager[]{versionRecordManager});
        Mockito.when((Object)versionRecordManager.getCurrentPath()).thenReturn((Object)this.observablePath);
        baseEditor.onRename();
        ((VersionRecordManager)Mockito.verify((Object)versionRecordManager)).init((String)Matchers.any(), (ObservablePath)Mockito.eq((Object)this.observablePath), (Callback)Matchers.any());
    }
}

