/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.popups;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.file.CommandWithFileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.popups.RenamePopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.commons.ToggleCommentPresenter;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;

@RunWith(value=MockitoJUnitRunner.class)
public class RenamePopUpPresenterTest {
    @Mock
    Path path;
    @Mock
    Validator validator;
    @Mock
    CommandWithFileNameAndCommitMessage renameCommand;
    @Mock
    CommandWithFileNameAndCommitMessage saveAndRenameCommand;
    @Mock
    ToggleCommentPresenter toggleCommentPresenter;
    @Mock
    RenamePopUpPresenter.View view;
    RenamePopUpPresenter presenter;

    @Before
    public void init() throws Exception {
        this.presenter = (RenamePopUpPresenter)Mockito.spy((Object)new RenamePopUpPresenter(this.view, this.toggleCommentPresenter));
    }

    @Test
    public void testSetup() throws Exception {
        this.presenter.setup();
        ((RenamePopUpPresenter.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
    }

    @Test
    public void testShow() throws Exception {
        this.presenter.show(this.path, this.validator, this.renameCommand);
        Assert.assertNotNull((Object)this.presenter.getPath());
        Assert.assertNotNull((Object)this.presenter.getValidator());
        Assert.assertNotNull((Object)this.presenter.getRenameCommand());
        ((RenamePopUpPresenter)Mockito.verify((Object)this.presenter)).setupView();
        ((RenamePopUpPresenter)Mockito.verify((Object)this.presenter)).showView();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testShowMissingPath() throws Exception {
        this.presenter.show(null, this.validator, this.renameCommand);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testShowMissingValidator() throws Exception {
        this.presenter.show(this.path, null, this.renameCommand);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testShowMissingRenameCommand() throws Exception {
        boolean isDirty = true;
        String fileName = "file.plugin";
        this.presenter.show(this.path, this.validator, null, this.saveAndRenameCommand, true, "file.plugin");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testShowMissingSaveAndRenameCommand() throws Exception {
        boolean isDirty = true;
        String fileName = "file.plugin";
        this.presenter.show(this.path, this.validator, this.renameCommand, null, true, "file.plugin");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testShowMissingCommand() throws Exception {
        this.presenter.show(this.path, this.validator, null);
    }

    @Test
    public void testShowWithDefaultValidator() throws Exception {
        this.presenter.show(this.path, this.renameCommand);
        Assert.assertNotNull((Object)this.presenter.getPath());
        Assert.assertNotNull((Object)this.presenter.getValidator());
        Assert.assertNotNull((Object)this.presenter.getRenameCommand());
        ((RenamePopUpPresenter)Mockito.verify((Object)this.presenter)).setupView();
        ((RenamePopUpPresenter)Mockito.verify((Object)this.presenter)).showView();
    }

    @Test
    public void testCancel() throws Exception {
        this.presenter.cancel();
        ((RenamePopUpPresenter.View)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testRename() throws Exception {
        Mockito.when((Object)this.path.getFileName()).thenReturn((Object)"file.plugin");
        this.presenter.show(this.path, this.validator, this.renameCommand);
        this.presenter.rename("newFile");
        ((Validator)Mockito.verify((Object)this.validator)).validate((String)Mockito.eq((Object)"newFile.plugin"), (ValidatorCallback)Mockito.any(ValidatorWithReasonCallback.class));
    }

    @Test
    public void testSaveAndRename() throws Exception {
        boolean isDirty = true;
        Mockito.when((Object)this.path.getFileName()).thenReturn((Object)"file.plugin");
        this.presenter.show(this.path, this.validator, true, this.renameCommand, this.saveAndRenameCommand);
        this.presenter.saveAndRename("newFile");
        ((Validator)Mockito.verify((Object)this.validator)).validate((String)Mockito.eq((Object)"newFile.plugin"), (ValidatorCallback)Mockito.any(ValidatorWithReasonCallback.class));
    }

    @Test
    public void testEnablePrimaryButtonWhenAssetIsDirty() {
        boolean isDirty = true;
        ((RenamePopUpPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isDirty();
        this.presenter.enablePrimaryButton();
        ((RenamePopUpPresenter.View)Mockito.verify((Object)this.view)).saveAndRenameAsPrimary();
    }

    @Test
    public void testEnablePrimaryButtonWhenAssetIsNotDirty() {
        boolean isDirty = false;
        ((RenamePopUpPresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).isDirty();
        this.presenter.enablePrimaryButton();
        ((RenamePopUpPresenter.View)Mockito.verify((Object)this.view)).renameAsPrimary();
    }

    @Test
    public void testHideSaveAndRenameIfAssetIsNotDirtyWhenAssetIsDirty() {
        boolean isDirty = true;
        boolean hidden = false;
        ((RenamePopUpPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isDirty();
        this.presenter.hideSaveAndRenameIfAssetIsNotDirty();
        ((RenamePopUpPresenter.View)Mockito.verify((Object)this.view)).hideSaveAndRename(false);
    }

    @Test
    public void testHideSaveAndRenameIfAssetIsNotDirtyWhenAssetIsNotDirty() {
        boolean isDirty = false;
        boolean hidden = true;
        ((RenamePopUpPresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).isDirty();
        this.presenter.hideSaveAndRenameIfAssetIsNotDirty();
        ((RenamePopUpPresenter.View)Mockito.verify((Object)this.view)).hideSaveAndRename(true);
    }

    @Test
    public void testSetupView() {
        this.presenter.setupView();
        ((RenamePopUpPresenter)Mockito.verify((Object)this.presenter)).enablePrimaryButton();
        ((RenamePopUpPresenter)Mockito.verify((Object)this.presenter)).hideSaveAndRenameIfAssetIsNotDirty();
    }

    @Test
    public void testShowView() {
        String originalFileName = "originalFileName";
        ((RenamePopUpPresenter)Mockito.doReturn((Object)"originalFileName").when((Object)this.presenter)).getOriginalFileName();
        this.presenter.showView();
        ((RenamePopUpPresenter.View)Mockito.verify((Object)this.view)).setOriginalFileName("originalFileName");
        ((RenamePopUpPresenter.View)Mockito.verify((Object)this.view)).show();
    }
}

