/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.popups;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.editor.commons.client.file.popups.DeletePopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.commons.ToggleCommentPresenter;
import org.uberfire.ext.editor.commons.client.validation.ValidationErrorReason;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=MockitoJUnitRunner.class)
public class DeletePopUpPresenterTest {
    @Mock
    DeletePopUpPresenter.View view;
    @Mock
    Validator validator;
    @Mock
    ParameterizedCommand<String> command;
    @Mock
    ToggleCommentPresenter toggleCommentPresenter;
    DeletePopUpPresenter presenter;

    @Before
    public void init() throws Exception {
        this.presenter = new DeletePopUpPresenter(this.view, this.toggleCommentPresenter);
    }

    @Test
    public void testSetup() throws Exception {
        this.presenter.setup();
        ((DeletePopUpPresenter.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
    }

    @Test
    public void testShow() throws Exception {
        this.presenter.show(this.validator, this.command);
        ((DeletePopUpPresenter.View)Mockito.verify((Object)this.view)).show();
        Assert.assertEquals((Object)this.validator, (Object)this.presenter.getValidator());
        Assert.assertEquals(this.command, (Object)this.presenter.getCommand());
    }

    @Test
    public void testDeleteWithCommand() throws Exception {
        Mockito.when((Object)this.toggleCommentPresenter.getComment()).thenReturn((Object)"test");
        this.presenter.show((value, callback) -> callback.onSuccess(), this.command);
        this.presenter.delete();
        ((ParameterizedCommand)Mockito.verify(this.command)).execute((Object)"test");
        ((DeletePopUpPresenter.View)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testDeleteWithValidationFailed() throws Exception {
        Mockito.when((Object)this.toggleCommentPresenter.getComment()).thenReturn((Object)"test");
        this.presenter.show((value, callback) -> callback.onFailure(), this.command);
        this.presenter.delete();
        ((ParameterizedCommand)Mockito.verify(this.command, (VerificationMode)Mockito.never())).execute((Object)"test");
        ((DeletePopUpPresenter.View)Mockito.verify((Object)this.view)).handleUnexpectedError();
    }

    @Test
    public void testNotAllowedDelete() throws Exception {
        Mockito.when((Object)this.toggleCommentPresenter.getComment()).thenReturn((Object)"test");
        this.presenter.show((value, callback) -> ((ValidatorWithReasonCallback)callback).onFailure(ValidationErrorReason.NOT_ALLOWED.name()), this.command);
        this.presenter.delete();
        ((ParameterizedCommand)Mockito.verify(this.command, (VerificationMode)Mockito.never())).execute((Object)"test");
        ((DeletePopUpPresenter.View)Mockito.verify((Object)this.view)).handleDeleteNotAllowed();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDeleteWithoutCommand() throws Exception {
        this.presenter.show(null, null);
        this.presenter.delete();
    }

    @Test
    public void cancel() throws Exception {
        this.presenter.cancel();
        ((DeletePopUpPresenter.View)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testPrompt() throws Exception {
        String prompt = "any text";
        this.presenter.setPrompt("any text");
        ((DeletePopUpPresenter.View)Mockito.verify((Object)this.view)).setPrompt("any text");
    }

    @Test
    public void testHiddenComment() throws Exception {
        this.presenter.setCommentIsHidden(true);
        ((ToggleCommentPresenter)Mockito.verify((Object)this.toggleCommentPresenter)).setHidden(true);
    }

    @Test
    public void testVisibleComment() throws Exception {
        this.presenter.setCommentIsHidden(false);
        ((ToggleCommentPresenter)Mockito.verify((Object)this.toggleCommentPresenter)).setHidden(false);
    }
}

