/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.htmleditor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.editor.commons.client.htmleditor.HtmlEditorLibraryLoader;
import org.uberfire.ext.editor.commons.client.htmleditor.HtmlEditorPresenter;
import org.uberfire.ext.editor.commons.client.htmleditor.HtmlEditorView;

@RunWith(value=GwtMockitoTestRunner.class)
public class HtmlEditorViewTest {
    private HtmlEditorLibraryLoader libraryLoader;
    private HtmlEditorPresenter presenter;
    private HtmlEditorView view;

    @Before
    public void setup() {
        TranslationService translationService = (TranslationService)Mockito.mock(TranslationService.class);
        this.libraryLoader = (HtmlEditorLibraryLoader)Mockito.mock(HtmlEditorLibraryLoader.class);
        this.view = (HtmlEditorView)Mockito.spy((Object)new HtmlEditorView(translationService, this.libraryLoader));
        ((HtmlEditorView)Mockito.doNothing().when((Object)this.view)).configureScreenComponents(Mockito.anyString(), Mockito.anyString());
        this.view.htmlEditor = (Div)Mockito.mock(Div.class);
        ((Div)Mockito.doReturn((Object)"content").when((Object)this.view.htmlEditor)).getInnerHTML();
        this.presenter = (HtmlEditorPresenter)Mockito.spy((Object)new HtmlEditorPresenter((HtmlEditorPresenter.View)this.view));
        ((HtmlEditorView)Mockito.doNothing().when((Object)this.view)).loadEditor(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void editorIsNotLoadedTwice() {
        this.presenter.load();
        this.presenter.load();
        ((HtmlEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).loadEditor(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void synchronizeViewWhenReturningContent() {
        this.presenter.getContent();
        ((HtmlEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).synchronizeView();
    }
}

