/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.popups;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.file.CommandWithFileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.popups.CopyPopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.commons.ToggleCommentPresenter;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;

@RunWith(value=MockitoJUnitRunner.class)
public class CopyPopUpPresenterTest {
    @Mock
    Path path;
    @Mock
    Validator validator;
    @Mock
    CommandWithFileNameAndCommitMessage command;
    @Mock
    ToggleCommentPresenter toggleCommentPresenter;
    @Mock
    CopyPopUpPresenter.View view;
    CopyPopUpPresenter presenter;

    @Before
    public void init() throws Exception {
        this.presenter = new CopyPopUpPresenter(this.view, this.toggleCommentPresenter);
    }

    @Test
    public void testSetup() throws Exception {
        this.presenter.setup();
        ((CopyPopUpPresenter.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
    }

    @Test
    public void testShow() throws Exception {
        this.presenter.show(this.path, this.validator, this.command);
        Assert.assertNotNull((Object)this.presenter.getPath());
        Assert.assertNotNull((Object)this.presenter.getValidator());
        Assert.assertNotNull((Object)this.presenter.getCommand());
        ((CopyPopUpPresenter.View)Mockito.verify((Object)this.view)).show();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testShowMissingPath() throws Exception {
        this.presenter.show(null, this.validator, this.command);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testShowMissingValidator() throws Exception {
        this.presenter.show(this.path, null, this.command);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testShowMissingCommand() throws Exception {
        this.presenter.show(this.path, this.validator, null);
    }

    @Test
    public void testShowWithDefaultValidator() throws Exception {
        this.presenter.show(this.path, this.command);
        Assert.assertNotNull((Object)this.presenter.getPath());
        Assert.assertNotNull((Object)this.presenter.getValidator());
        Assert.assertNotNull((Object)this.presenter.getCommand());
        ((CopyPopUpPresenter.View)Mockito.verify((Object)this.view)).show();
    }

    @Test
    public void testCancel() throws Exception {
        this.presenter.cancel();
        ((CopyPopUpPresenter.View)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testCopy() throws Exception {
        Mockito.when((Object)this.path.getFileName()).thenReturn((Object)"file.plugin");
        Mockito.when((Object)this.toggleCommentPresenter.getComment()).thenReturn((Object)"comment");
        this.presenter.show(this.path, this.validator, this.command);
        this.presenter.copy("newFile");
        ((Validator)Mockito.verify((Object)this.validator)).validate((String)Mockito.eq((Object)"newFile.plugin"), (ValidatorCallback)Mockito.any(ValidatorWithReasonCallback.class));
    }
}

