/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.htmleditor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.function.Supplier;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.htmleditor.HtmlEditor;
import org.uberfire.ext.editor.commons.client.htmleditor.HtmlEditorPresenter;
import org.uberfire.ext.editor.commons.client.htmleditor.HtmlResourceType;
import org.uberfire.ext.editor.commons.service.htmleditor.HtmlEditorService;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class HtmlEditorTest {
    @Mock
    private HtmlResourceType htmlResourceType;
    @Mock
    private HtmlEditorPresenter presenter;
    @Mock
    private HtmlEditorService htmlEditorService;
    @Mock
    private VersionRecordManager versionRecordManagerMock;
    @Mock
    private BaseEditorView baseViewMock;
    private Caller<HtmlEditorService> htmlEditorServiceCaller;
    private HtmlEditor htmlEditor;

    @Before
    public void setup() {
        this.htmlEditorServiceCaller = new CallerMock((Object)this.htmlEditorService);
        this.htmlEditor = (HtmlEditor)Mockito.spy((Object)new HtmlEditor(this.htmlResourceType, this.presenter, this.htmlEditorServiceCaller){
            {
                this.baseView = HtmlEditorTest.this.baseViewMock;
                this.versionRecordManager = HtmlEditorTest.this.versionRecordManagerMock;
            }
        });
    }

    @Test
    public void testGetContentSupplier() {
        String content = "content";
        ((HtmlEditorPresenter)Mockito.doReturn((Object)"content").when((Object)this.presenter)).getContent();
        Supplier contentSupplier = this.htmlEditor.getContentSupplier();
        Assert.assertEquals((Object)"content", contentSupplier.get());
    }

    @Test
    public void testGetSaveAndRenameServiceCaller() {
        Assert.assertEquals(this.htmlEditorServiceCaller, (Object)this.htmlEditor.getSaveAndRenameServiceCaller());
    }

    @Test
    public void testLoadContent() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        ((VersionRecordManager)Mockito.doReturn((Object)path).when((Object)this.versionRecordManagerMock)).getCurrentPath();
        this.htmlEditor.loadContent();
        ((BaseEditorView)Mockito.verify((Object)this.baseViewMock)).hideBusyIndicator();
        ((HtmlEditorService)Mockito.verify((Object)this.htmlEditorService)).load((Path)path);
        ((HtmlEditorPresenter)Mockito.verify((Object)this.presenter)).setContent((String)Matchers.any());
    }

    @Test
    public void testSave() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        RemoteCallback successCallback = (RemoteCallback)Mockito.mock(RemoteCallback.class);
        String content = "content";
        ((HtmlEditorPresenter)Mockito.doReturn((Object)"content").when((Object)this.presenter)).getContent();
        ((VersionRecordManager)Mockito.doReturn((Object)path).when((Object)this.versionRecordManagerMock)).getCurrentPath();
        ((HtmlEditor)Mockito.doReturn((Object)successCallback).when((Object)this.htmlEditor)).getSaveSuccessCallback(Matchers.anyInt());
        this.htmlEditor.save();
        ((HtmlEditorService)Mockito.verify((Object)this.htmlEditorService)).save((Path)path, (Object)"content", null, null);
        ((RemoteCallback)Mockito.verify((Object)successCallback)).callback(Matchers.any());
    }
}

