/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.promise.Promises;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.BaseEditor;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.EditorTitle;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.menu.DownloadMenuItemBuilder;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.client.menu.common.SaveAndRenameCommandBuilder;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.file.DefaultMetadata;
import org.uberfire.ext.widgets.common.client.common.ConcurrentChangePopup;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.promise.SyncPromises;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class BaseEditorTest {
    private String fakeContent = "fakeContent";
    @Mock
    private VersionRecordManager versionRecordManager;
    @Mock
    private BaseEditorView baseView;
    @Mock
    private BasicFileMenuBuilder menuBuilder;
    @Mock
    private EventSourceMock<ChangeTitleWidgetEvent> changeTitleNotification;
    @Mock
    private DownloadMenuItemBuilder downloadMenuItem;
    private SaveAndRenameCommandBuilder<String, DefaultMetadata> builder = (SaveAndRenameCommandBuilder)Mockito.spy(this.makeBuilder());
    private Promises promises;
    @InjectMocks
    private BaseEditor<String, DefaultMetadata> editor = (BaseEditor)Mockito.spy(this.makeBaseEditor());

    @Test
    public void testSaveAndRename() {
        Supplier pathSupplier = (Supplier)Mockito.mock(Supplier.class);
        Validator renameValidator = (Validator)Mockito.mock(Validator.class);
        Supplier saveValidator = (Supplier)Mockito.mock(Supplier.class);
        Caller supportsSaveAndRename = (Caller)Mockito.mock(Caller.class);
        Supplier metadataSupplier = (Supplier)Mockito.mock(Supplier.class);
        Supplier contentSupplier = (Supplier)Mockito.mock(Supplier.class);
        Supplier isDirtySupplier = (Supplier)Mockito.mock(Supplier.class);
        ParameterizedCommand parameterizedCommand = (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class);
        Command command = (Command)Mockito.mock(Command.class);
        Command beforeSaveCommand = (Command)Mockito.mock(Command.class);
        ((BaseEditor)Mockito.doReturn((Object)pathSupplier).when(this.editor)).getPathSupplier();
        ((BaseEditor)Mockito.doReturn((Object)renameValidator).when(this.editor)).getRenameValidator();
        ((BaseEditor)Mockito.doReturn((Object)saveValidator).when(this.editor)).getSaveValidator();
        ((BaseEditor)Mockito.doReturn((Object)supportsSaveAndRename).when(this.editor)).getSaveAndRenameServiceCaller();
        ((BaseEditor)Mockito.doReturn((Object)metadataSupplier).when(this.editor)).getMetadataSupplier();
        ((BaseEditor)Mockito.doReturn((Object)contentSupplier).when(this.editor)).getContentSupplier();
        ((BaseEditor)Mockito.doReturn((Object)isDirtySupplier).when(this.editor)).isDirtySupplier();
        ((BaseEditor)Mockito.doReturn((Object)parameterizedCommand).when(this.editor)).onSuccess();
        ((BaseEditor)Mockito.doReturn((Object)beforeSaveCommand).when(this.editor)).getBeforeSaveAndRenameCommand();
        ((SaveAndRenameCommandBuilder)Mockito.doReturn((Object)command).when(this.builder)).build();
        Command saveAndRenameCommand = this.editor.getSaveAndRename();
        Assert.assertEquals((Object)command, (Object)saveAndRenameCommand);
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder)).addPathSupplier(pathSupplier);
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder)).addValidator(renameValidator);
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder)).addValidator(saveValidator);
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder)).addRenameService(supportsSaveAndRename);
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder)).addMetadataSupplier(metadataSupplier);
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder)).addContentSupplier(contentSupplier);
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder)).addIsDirtySupplier(isDirtySupplier);
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder)).addSuccessCallback(parameterizedCommand);
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder)).addBeforeSaveAndRenameCommand(beforeSaveCommand);
    }

    @Test
    public void testGetPathSupplier() {
        ObservablePath observablePath = (ObservablePath)Mockito.mock(ObservablePath.class);
        ((VersionRecordManager)Mockito.doReturn((Object)observablePath).when((Object)this.versionRecordManager)).getPathToLatest();
        Supplier pathSupplier = this.editor.getPathSupplier();
        Assert.assertEquals((Object)observablePath, pathSupplier.get());
    }

    @Test
    public void testGetContentSupplier() {
        Supplier contentSupplier = this.editor.getContentSupplier();
        String content = (String)contentSupplier.get();
        Assert.assertEquals((Object)this.fakeContent, (Object)content);
    }

    @Test
    public void testGetMetadataSupplier() {
        Assert.assertNull(this.editor.getMetadataSupplier().get());
    }

    @Test
    public void testGetSaveAndRenameServiceCaller() {
        Assert.assertNull((Object)this.editor.getSaveAndRenameServiceCaller());
    }

    @Test
    public void testIsContentDirtyWhenEditorIsDirty() {
        ((BaseEditor)Mockito.doReturn((Object)true).when(this.editor)).isDirty(Integer.valueOf(this.fakeContent.hashCode()));
        Assert.assertTrue((boolean)this.editor.isContentDirty());
    }

    @Test
    public void testIsContentDirtyWhenEditorIsNotDirty() {
        ((BaseEditor)Mockito.doReturn((Object)false).when(this.editor)).isDirty(Integer.valueOf(this.fakeContent.hashCode()));
        Assert.assertFalse((boolean)this.editor.isContentDirty());
    }

    @Test
    public void testIsContentDirtyWhenGetContentRaisesAnException() {
        ((BaseEditor)Mockito.doReturn(null).when(this.editor)).getContentSupplier();
        Assert.assertFalse((boolean)this.editor.isContentDirty());
    }

    @Test
    public void testIsMetadataDirtyWhenMetadataIsDirty() {
        DefaultMetadata metadata = this.fakeMetadata(123);
        Supplier<DefaultMetadata> metadataSupplier = () -> metadata;
        ((BaseEditor)Mockito.doReturn(metadataSupplier).when(this.editor)).getMetadataSupplier();
        this.editor.metadataOriginalHash = 456;
        Assert.assertTrue((boolean)this.editor.isMetadataDirty());
    }

    @Test
    public void testIsMetadataDirtyWhenMetadataIsNotDirty() {
        DefaultMetadata metadata = this.fakeMetadata(123);
        Supplier<DefaultMetadata> metadataSupplier = () -> metadata;
        ((BaseEditor)Mockito.doReturn(metadataSupplier).when(this.editor)).getMetadataSupplier();
        this.editor.metadataOriginalHash = 123;
        Assert.assertFalse((boolean)this.editor.isMetadataDirty());
    }

    @Test
    public void testIsMetadataDirtyWhenMetadataIsNull() {
        Assert.assertFalse((boolean)this.editor.isMetadataDirty());
    }

    @Test
    public void testIsDirtySupplierWhenContentIsDirty() {
        ((BaseEditor)Mockito.doReturn((Object)true).when(this.editor)).isContentDirty();
        ((BaseEditor)Mockito.doReturn((Object)false).when(this.editor)).isMetadataDirty();
        Assert.assertTrue((boolean)((Boolean)this.editor.isDirtySupplier().get()));
    }

    @Test
    public void testIsDirtySupplierWhenMetadataIsDirty() {
        ((BaseEditor)Mockito.doReturn((Object)false).when(this.editor)).isContentDirty();
        ((BaseEditor)Mockito.doReturn((Object)true).when(this.editor)).isMetadataDirty();
        Assert.assertTrue((boolean)((Boolean)this.editor.isDirtySupplier().get()));
    }

    @Test
    public void testIsDirtySupplierWhenContentAndMetdataAreDirty() {
        ((BaseEditor)Mockito.doReturn((Object)true).when(this.editor)).isContentDirty();
        ((BaseEditor)Mockito.doReturn((Object)true).when(this.editor)).isMetadataDirty();
        Assert.assertTrue((boolean)((Boolean)this.editor.isDirtySupplier().get()));
    }

    @Test
    public void testIsDirtySupplierWhenContentAndMetdataAreNotDirty() {
        ((BaseEditor)Mockito.doReturn((Object)false).when(this.editor)).isContentDirty();
        ((BaseEditor)Mockito.doReturn((Object)false).when(this.editor)).isMetadataDirty();
        Assert.assertFalse((boolean)((Boolean)this.editor.isDirtySupplier().get()));
    }

    @Test
    public void testGetSaveValidatorWhenItIsReadOnlyAndItIsCurrentLatest() {
        this.editor.isReadOnly = true;
        ((VersionRecordManager)Mockito.doReturn((Object)true).when((Object)this.versionRecordManager)).isCurrentLatest();
        boolean success = (Boolean)this.editor.getSaveValidator().get();
        ((BaseEditorView)Mockito.verify((Object)this.baseView)).alertReadOnly();
        Assert.assertFalse((boolean)success);
    }

    @Test
    public void testGetSaveValidatorWhenItIsReadOnlyAndItIsNotCurrentLatest() {
        this.editor.isReadOnly = true;
        ((VersionRecordManager)Mockito.doReturn((Object)false).when((Object)this.versionRecordManager)).isCurrentLatest();
        boolean success = (Boolean)this.editor.getSaveValidator().get();
        ((VersionRecordManager)Mockito.verify((Object)this.versionRecordManager)).restoreToCurrentVersion(true);
        Assert.assertFalse((boolean)success);
    }

    @Test
    public void testGetSaveValidatorWhenConcurrentUpdateSessionInfoIsNotNull() {
        this.editor.isReadOnly = false;
        this.editor.concurrentUpdateSessionInfo = (ObservablePath.OnConcurrentUpdateEvent)Mockito.mock(ObservablePath.OnConcurrentUpdateEvent.class);
        ((BaseEditor)Mockito.doNothing().when(this.editor)).showConcurrentUpdatePopup();
        boolean success = (Boolean)this.editor.getSaveValidator().get();
        ((BaseEditor)Mockito.verify(this.editor)).showConcurrentUpdatePopup();
        Assert.assertFalse((boolean)success);
    }

    @Test
    public void testGetSaveValidatorWhenConcurrentUpdateSessionInfoIsNull() {
        this.editor.isReadOnly = false;
        this.editor.concurrentUpdateSessionInfo = null;
        boolean success = (Boolean)this.editor.getSaveValidator().get();
        Assert.assertTrue((boolean)success);
    }

    @Test
    public void testOnSuccess() {
        Path path = (Path)Mockito.mock(Path.class);
        String content = "content";
        int contentHash = "content".hashCode();
        int metadataHash = 456;
        Supplier<String> contentSupplier = () -> "content";
        Supplier<DefaultMetadata> metadataSupplier = () -> this.fakeMetadata(456);
        ((BaseEditor)Mockito.doReturn(contentSupplier).when(this.editor)).getContentSupplier();
        ((BaseEditor)Mockito.doReturn(metadataSupplier).when(this.editor)).getMetadataSupplier();
        this.editor.onSuccess().execute((Object)path);
        ((BaseEditor)Mockito.verify(this.editor)).setOriginalHash(Integer.valueOf(contentHash));
        ((BaseEditor)Mockito.verify(this.editor)).setMetadataOriginalHash(Integer.valueOf(456));
    }

    @Test
    public void testOnSuccessShouldNotCallMetadataHashIfNotAvailable() {
        Path path = (Path)Mockito.mock(Path.class);
        String content = "dora";
        int contentHash = "dora".hashCode();
        int metadataHash = 456;
        Supplier<String> contentSupplier = () -> "dora";
        Supplier<DefaultMetadata> metadataSupplier = () -> null;
        ((BaseEditor)Mockito.doReturn(contentSupplier).when(this.editor)).getContentSupplier();
        ((BaseEditor)Mockito.doReturn(metadataSupplier).when(this.editor)).getMetadataSupplier();
        this.editor.onSuccess().execute((Object)path);
        ((BaseEditor)Mockito.verify(this.editor)).setOriginalHash(Integer.valueOf(contentHash));
        ((BaseEditor)Mockito.verify(this.editor, (VerificationMode)Mockito.never())).setMetadataOriginalHash(Integer.valueOf(456));
    }

    @Test
    public void testMakeMenuBarWhenItContainsAllMenuItems() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        MenuItem menuItem = (MenuItem)Mockito.mock(MenuItem.class);
        Command onValidate = (Command)Mockito.mock(Command.class);
        Command onSave = (Command)Mockito.mock(Command.class);
        Command saveAndRename = (Command)Mockito.mock(Command.class);
        Validator validator = (Validator)Mockito.mock(Validator.class);
        Validator copyValidator = (Validator)Mockito.mock(Validator.class);
        Caller copyServiceCaller = (Caller)Mockito.mock(Caller.class);
        Caller deleteServiceCaller = (Caller)Mockito.mock(Caller.class);
        MenuItem downloadMenuItemButton = (MenuItem)Mockito.mock(MenuItem.class);
        Mockito.when((Object)this.downloadMenuItem.build((Supplier)ArgumentMatchers.any())).thenReturn((Object)downloadMenuItemButton);
        this.editor.menuItems = new HashSet<MenuItems>(Arrays.asList(MenuItems.SAVE, MenuItems.COPY, MenuItems.RENAME, MenuItems.DELETE, MenuItems.VALIDATE, MenuItems.HISTORY, MenuItems.DOWNLOAD));
        ((VersionRecordManager)Mockito.doReturn((Object)path).when((Object)this.versionRecordManager)).getCurrentPath();
        ((VersionRecordManager)Mockito.doReturn((Object)menuItem).when((Object)this.versionRecordManager)).buildMenu();
        ((BaseEditor)Mockito.doReturn((Object)onValidate).when(this.editor)).getValidateCommand();
        ((BaseEditor)Mockito.doReturn((Object)onSave).when(this.editor)).getOnSave();
        ((BaseEditor)Mockito.doReturn((Object)saveAndRename).when(this.editor)).getSaveAndRename();
        ((BaseEditor)Mockito.doReturn((Object)validator).when(this.editor)).getCopyValidator();
        ((BaseEditor)Mockito.doReturn((Object)copyValidator).when(this.editor)).getCopyValidator();
        ((BaseEditor)Mockito.doReturn((Object)copyServiceCaller).when(this.editor)).getCopyServiceCaller();
        ((BaseEditor)Mockito.doReturn((Object)deleteServiceCaller).when(this.editor)).getDeleteServiceCaller();
        this.editor.makeMenuBar();
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addSave(onSave);
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addCopy((Path)path, copyValidator, copyServiceCaller);
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addRename(saveAndRename);
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addDelete((Path)path, deleteServiceCaller);
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addValidate(onValidate);
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addNewTopLevelMenu(menuItem);
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder)).addNewTopLevelMenu(downloadMenuItemButton);
    }

    @Test
    public void testMakeMenuBarWhenItDoesNotContainAllMenuItems() {
        this.editor.menuItems = new HashSet();
        this.editor.makeMenuBar();
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder, (VerificationMode)Mockito.never())).addSave((Command)ArgumentMatchers.any(Command.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder, (VerificationMode)Mockito.never())).addCopy((Path)ArgumentMatchers.any(ObservablePath.class), (Validator)ArgumentMatchers.any(Validator.class), (Caller)ArgumentMatchers.any(Caller.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder, (VerificationMode)Mockito.never())).addRename((Command)ArgumentMatchers.any());
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder, (VerificationMode)Mockito.never())).addDelete((Path)ArgumentMatchers.any(ObservablePath.class), (Caller)ArgumentMatchers.any(Caller.class));
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder, (VerificationMode)Mockito.never())).addValidate((Command)ArgumentMatchers.any());
        ((BasicFileMenuBuilder)Mockito.verify((Object)this.menuBuilder, (VerificationMode)Mockito.never())).addNewTopLevelMenu((MenuItem)ArgumentMatchers.any());
    }

    @Test
    public void testReloadWithObservablePath() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        ((BaseEditor)Mockito.doNothing().when(this.editor)).refreshTitle(path);
        ((BaseEditor)Mockito.doNothing().when(this.editor)).showBusyIndicator();
        ((BaseEditor)Mockito.doNothing().when(this.editor)).loadContent();
        ((BaseEditor)Mockito.doNothing().when(this.editor)).notifyChangeTitle(path);
        ((BaseEditor)Mockito.doNothing().when(this.editor)).initVersionRecordManager();
        this.editor.reload(path);
        ((BaseEditor)Mockito.verify(this.editor)).refreshTitle(path);
        ((BaseEditor)Mockito.verify(this.editor)).showBusyIndicator();
        ((BaseEditor)Mockito.verify(this.editor)).loadContent();
        ((BaseEditor)Mockito.verify(this.editor)).notifyChangeTitle(path);
        ((BaseEditor)Mockito.verify(this.editor)).initVersionRecordManager();
    }

    @Test
    public void testRefreshTitleWithObservablePath() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        String title = "title";
        ((BaseEditor)Mockito.doReturn((Object)"title").when(this.editor)).getTitleText(path);
        this.editor.refreshTitle(path);
        ((BaseEditorView)Mockito.verify((Object)this.baseView)).refreshTitle("title");
    }

    @Test
    public void testShowBusyIndicator() {
        String loading = "Loading...";
        ((BaseEditor)Mockito.doReturn((Object)"Loading...").when(this.editor)).makeLoading();
        this.editor.showBusyIndicator();
        ((BaseEditorView)Mockito.verify((Object)this.baseView)).showBusyIndicator("Loading...");
    }

    @Test
    public void testNotifyChangeTitle() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        ChangeTitleWidgetEvent widgetEvent = (ChangeTitleWidgetEvent)Mockito.mock(ChangeTitleWidgetEvent.class);
        ((BaseEditor)Mockito.doReturn((Object)widgetEvent).when(this.editor)).makeChangeTitleWidgetEvent(path);
        this.editor.notifyChangeTitle(path);
        ((EventSourceMock)Mockito.verify(this.changeTitleNotification)).fire((Object)widgetEvent);
    }

    @Test
    public void testMakeChangeTitleWidgetEvent() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        String title = "title";
        EditorTitle editorTitle = (EditorTitle)Mockito.mock(EditorTitle.class);
        ((BaseEditor)Mockito.doReturn((Object)placeRequest).when(this.editor)).getPlace();
        ((BaseEditor)Mockito.doReturn((Object)"title").when(this.editor)).getTitleText(path);
        ((BaseEditor)Mockito.doReturn((Object)editorTitle).when(this.editor)).getTitleWidget();
        ChangeTitleWidgetEvent event = this.editor.makeChangeTitleWidgetEvent(path);
        Assert.assertEquals((Object)placeRequest, (Object)event.getPlaceRequest());
        Assert.assertEquals((Object)"title", (Object)event.getTitle());
        Assert.assertEquals((Object)editorTitle, (Object)event.getTitleDecoration());
    }

    @Test
    public void testInitVersionRecordManager() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        String version = "version";
        Callback selectionCallback = v -> {};
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)path);
        Mockito.when((Object)placeRequest.getParameter(ArgumentMatchers.anyString(), (String)ArgumentMatchers.any())).thenReturn((Object)"version");
        ((BaseEditor)Mockito.doReturn((Object)selectionCallback).when(this.editor)).getSelectVersion();
        ((BaseEditor)Mockito.doReturn((Object)placeRequest).when(this.editor)).getPlace();
        this.editor.initVersionRecordManager();
        ((VersionRecordManager)Mockito.verify((Object)this.versionRecordManager)).init("version", path, selectionCallback);
    }

    @Test
    public void testGetTitleText() {
        String expectedTitle = "file.drl - DRL";
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        ClientResourceType type = (ClientResourceType)Mockito.mock(ClientResourceType.class);
        ((BaseEditor)Mockito.doReturn((Object)type).when(this.editor)).getType();
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"file.drl");
        Mockito.when((Object)type.getDescription()).thenReturn((Object)"DRL");
        String actualTitle = this.editor.getTitleText(path);
        Assert.assertEquals((Object)"file.drl - DRL", (Object)actualTitle);
    }

    @Test
    public void testGetTitle() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        EditorTitle expectedTitle = (EditorTitle)Mockito.mock(EditorTitle.class);
        ((BaseEditor)Mockito.doNothing().when(this.editor)).refreshTitle(path);
        ((BaseEditor)Mockito.doReturn((Object)expectedTitle).when(this.editor)).getTitleWidget();
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)path);
        IsWidget actualWidget = this.editor.getTitle();
        ((BaseEditor)Mockito.verify(this.editor)).refreshTitle(path);
        Assert.assertEquals((Object)expectedTitle, (Object)actualWidget);
    }

    @Test
    public void testGetCurrentContentHashWhenContentSupplierRaisesAnException() {
        this.fakeContent = null;
        Integer actualHash = this.editor.getCurrentContentHash();
        Object expectedHash = null;
        Assert.assertEquals(expectedHash, (Object)actualHash);
    }

    @Test
    public void testGetCurrentContentHash() {
        Integer actualHash = this.editor.getCurrentContentHash();
        Integer expectedHash = this.fakeContent.hashCode();
        Assert.assertEquals((Object)expectedHash, (Object)actualHash);
    }

    @Test
    public void testDisableMenuItem() {
        Menus menus = (Menus)Mockito.mock(Menus.class);
        MenuItem menuItem = (MenuItem)Mockito.mock(MenuItem.class);
        HashMap<MenuItems, MenuItem> itemMap = new HashMap<MenuItems, MenuItem>();
        itemMap.put(MenuItems.SAVE, menuItem);
        Mockito.when((Object)menus.getItemsMap()).thenReturn(itemMap);
        ((BaseEditor)Mockito.doAnswer(invocationOnMock -> {
            ((Consumer)invocationOnMock.getArgument(0, Consumer.class)).accept(menus);
            return null;
        }).when(this.editor)).getMenus((Consumer)ArgumentMatchers.any());
        this.editor.disableMenuItem(MenuItems.SAVE);
        ((MenuItem)Mockito.verify((Object)menuItem)).setEnabled(false);
    }

    @Test
    public void testEnableMenuItem() {
        Menus menus = (Menus)Mockito.mock(Menus.class);
        MenuItem menuItem = (MenuItem)Mockito.mock(MenuItem.class);
        HashMap<MenuItems, MenuItem> itemMap = new HashMap<MenuItems, MenuItem>();
        itemMap.put(MenuItems.SAVE, menuItem);
        Mockito.when((Object)menus.getItemsMap()).thenReturn(itemMap);
        ((BaseEditor)Mockito.doAnswer(invocationOnMock -> {
            ((Consumer)invocationOnMock.getArgument(0, Consumer.class)).accept(menus);
            return null;
        }).when(this.editor)).getMenus((Consumer)ArgumentMatchers.any());
        this.editor.enableMenuItem(MenuItems.SAVE);
        ((MenuItem)Mockito.verify((Object)menuItem)).setEnabled(true);
    }

    @Test
    public void testShowConcurrentUpdatePopupTwice() {
        ConcurrentChangePopup concurrentChangePopup = (ConcurrentChangePopup)Mockito.mock(ConcurrentChangePopup.class);
        ((BaseEditor)Mockito.doReturn((Object)concurrentChangePopup).when(this.editor)).getConcurrentUpdatePopup();
        this.editor.showConcurrentUpdatePopup();
        this.editor.showConcurrentUpdatePopup();
        ((BaseEditor)Mockito.verify(this.editor, (VerificationMode)Mockito.times((int)1))).getConcurrentUpdatePopup();
        ((ConcurrentChangePopup)Mockito.verify((Object)concurrentChangePopup, (VerificationMode)Mockito.times((int)2))).show();
    }

    private DefaultMetadata fakeMetadata(final int hashCode) {
        return new DefaultMetadata(){

            public int hashCode() {
                return hashCode;
            }
        };
    }

    private SaveAndRenameCommandBuilder<String, DefaultMetadata> makeBuilder() {
        return new SaveAndRenameCommandBuilder(null, null, null, null);
    }

    private BaseEditor<String, DefaultMetadata> makeBaseEditor() {
        this.promises = new SyncPromises();
        return new BaseEditor<String, DefaultMetadata>(){
            {
                this.promises = BaseEditorTest.this.promises;
            }

            protected SaveAndRenameCommandBuilder<String, DefaultMetadata> getSaveAndRenameCommandBuilder() {
                return BaseEditorTest.this.builder;
            }

            protected void loadContent() {
            }

            protected Supplier<String> getContentSupplier() {
                return () -> BaseEditorTest.this.fakeContent;
            }
        };
    }
}

