/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.history;

import com.google.gwt.view.client.AsyncDataProvider;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.history.VersionHistoryPresenter;
import org.uberfire.ext.editor.commons.client.history.VersionHistoryPresenterView;
import org.uberfire.ext.editor.commons.client.history.event.VersionSelectedEvent;
import org.uberfire.ext.editor.commons.version.VersionService;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.mocks.EventSourceMock;

public class VersionHistoryPresenterTest {
    private VersionHistoryPresenterView view;
    private VersionHistoryPresenterView.Presenter presenter;
    private VersionService service;
    private VersionHistoryPresenter screen;
    private List<VersionRecord> records = new ArrayList<VersionRecord>();
    private VersionSelectedEventMock event;
    private Path path111;
    private Path path222;
    private Path path333;

    @Before
    public void setUp() throws Exception {
        this.view = (VersionHistoryPresenterView)Mockito.mock(VersionHistoryPresenterView.class);
        this.path111 = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)this.path111.toURI()).thenReturn((Object)"hehe//test.file");
        this.path222 = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)this.path222.toURI()).thenReturn((Object)"hehe//test.file");
        this.path333 = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)this.path333.toURI()).thenReturn((Object)"hehe//test.file");
        this.event = (VersionSelectedEventMock)((Object)Mockito.mock(VersionSelectedEventMock.class));
        this.screen = new VersionHistoryPresenter(this.view, (Caller)new VersionServiceMock(), (Event)this.event);
        this.presenter = this.screen;
    }

    @Test
    public void testSetPresenter() throws Exception {
        ((VersionHistoryPresenterView)Mockito.verify((Object)this.view)).setPresenter(this.presenter);
    }

    @Test
    public void testLoadHistory() throws Exception {
        VersionRecord versionRecord1 = this.getVersionRecord("111");
        this.records.add(versionRecord1);
        VersionRecord versionRecord2 = this.getVersionRecord("222");
        this.records.add(versionRecord2);
        VersionRecord versionRecord3 = this.getVersionRecord("333");
        this.records.add(versionRecord3);
        this.screen.init(this.path333);
        this.screen.refresh("333");
        ((VersionHistoryPresenterView)Mockito.verify((Object)this.view)).setup((String)Mockito.eq((Object)"333"), (AsyncDataProvider)Mockito.any(AsyncDataProvider.class));
    }

    @Test
    public void testSelectVersion() throws Exception {
        VersionRecord versionRecord1 = this.getVersionRecord("111");
        this.records.add(versionRecord1);
        VersionRecord versionRecord2 = this.getVersionRecord("222");
        this.records.add(versionRecord2);
        this.screen.init(this.path222);
        this.screen.onSelect(versionRecord1);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(VersionSelectedEvent.class);
        ((VersionSelectedEventMock)((Object)Mockito.verify((Object)((Object)this.event)))).fire(argumentCaptor.capture());
        Assert.assertEquals((Object)versionRecord1, (Object)((VersionSelectedEvent)argumentCaptor.getValue()).getVersionRecord());
    }

    @Test
    public void testVersionChanges() throws Exception {
        VersionRecord versionRecord1 = this.getVersionRecord("111");
        this.records.add(versionRecord1);
        VersionRecord versionRecord2 = this.getVersionRecord("222");
        this.records.add(versionRecord2);
        this.screen.init(this.path222);
        this.screen.refresh("222");
        ((VersionHistoryPresenterView)Mockito.verify((Object)this.view)).setup((String)Mockito.eq((Object)"222"), (AsyncDataProvider)Mockito.any(AsyncDataProvider.class));
        Path pathToFile = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)pathToFile.toURI()).thenReturn((Object)"hehe//test.file");
        this.screen.onVersionChange(new VersionSelectedEvent(pathToFile, versionRecord1));
        ((VersionHistoryPresenterView)Mockito.verify((Object)this.view)).setup((String)Mockito.eq((Object)"111"), (AsyncDataProvider)Mockito.any(AsyncDataProvider.class));
    }

    @Test
    public void testVersionChangeForSomeOtherFile() throws Exception {
        VersionRecord versionRecord1 = this.getVersionRecord("111");
        this.records.add(versionRecord1);
        VersionRecord versionRecord2 = this.getVersionRecord("222");
        this.records.add(versionRecord2);
        this.screen.init(this.path222);
        this.screen.refresh("222");
        ((VersionHistoryPresenterView)Mockito.verify((Object)this.view)).setup((String)Mockito.eq((Object)"222"), (AsyncDataProvider)Mockito.any(AsyncDataProvider.class));
        Path pathToFile = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)pathToFile.toURI()).thenReturn((Object)"hehe//another.file");
        this.screen.onVersionChange(new VersionSelectedEvent(pathToFile, this.getVersionRecord("111")));
        ((VersionHistoryPresenterView)Mockito.verify((Object)this.view)).setup((String)Mockito.eq((Object)"222"), (AsyncDataProvider)Mockito.any(AsyncDataProvider.class));
    }

    private VersionRecord getVersionRecord(String version) {
        VersionRecord versionRecord = (VersionRecord)Mockito.mock(VersionRecord.class);
        Mockito.when((Object)versionRecord.id()).thenReturn((Object)version);
        Mockito.when((Object)versionRecord.uri()).thenReturn((Object)"hehe//test.file");
        return versionRecord;
    }

    private class VersionSelectedEventMock
    extends EventSourceMock<VersionSelectedEvent> {
        private VersionSelectedEventMock() {
        }
    }

    private class VersionServiceMock
    implements Caller<VersionService> {
        RemoteCallback callback;

        private VersionServiceMock() {
            VersionHistoryPresenterTest.this.service = new VersionService(){

                public List<VersionRecord> getVersions(Path path) {
                    VersionServiceMock.this.callback.callback((Object)VersionHistoryPresenterTest.this.records);
                    return null;
                }

                public Path getPathToPreviousVersion(String uri) {
                    return null;
                }

                public Path restore(Path path, String comment, String currentBranch) {
                    return null;
                }
            };
        }

        public VersionService call() {
            return VersionHistoryPresenterTest.this.service;
        }

        public VersionService call(RemoteCallback<?> remoteCallback) {
            this.callback = remoteCallback;
            return VersionHistoryPresenterTest.this.service;
        }

        public VersionService call(RemoteCallback<?> remoteCallback, ErrorCallback<?> errorCallback) {
            this.callback = remoteCallback;
            return VersionHistoryPresenterTest.this.service;
        }
    }
}

