/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.menu;

import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.net.URL;
import java.util.function.Supplier;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.menu.DownloadMenuItemBuilder;
import org.uberfire.mvp.Command;

@WithClassesToStub(value={URL.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class DownloadMenuItemBuilderTest {
    @Mock
    private TranslationService translationService;
    @Mock
    private Path path;
    private Supplier<Path> pathSupplier = () -> this.path;
    private DownloadMenuItemBuilder downloadMenuItemBuilder;

    @Before
    public void setup() {
        this.downloadMenuItemBuilder = (DownloadMenuItemBuilder)Mockito.spy((Object)new DownloadMenuItemBuilder(this.translationService));
    }

    @Test
    public void testBuild() {
        String caption = "Download";
        Command menuItemCommand = () -> {};
        Mockito.when((Object)this.translationService.format("DownloadMenuItem.Download", new Object[0])).thenReturn((Object)"Download");
        ((DownloadMenuItemBuilder)Mockito.doReturn((Object)menuItemCommand).when((Object)this.downloadMenuItemBuilder)).makeMenuItemCommand(this.pathSupplier);
        this.downloadMenuItemBuilder.build(this.pathSupplier);
        ((DownloadMenuItemBuilder)Mockito.verify((Object)this.downloadMenuItemBuilder)).makeMenuItem((String)ArgumentMatchers.eq((Object)"Download"), (Command)ArgumentMatchers.eq((Object)menuItemCommand));
    }

    @Test
    public void testMenuItemCommand() {
        Command command = this.downloadMenuItemBuilder.makeMenuItemCommand(this.pathSupplier);
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)"default://main@MySpace/Mortgages/src/main/resources/rule.drl");
        ((DownloadMenuItemBuilder)Mockito.doNothing().when((Object)this.downloadMenuItemBuilder)).open((String)ArgumentMatchers.any());
        command.execute();
        ((DownloadMenuItemBuilder)Mockito.verify((Object)this.downloadMenuItemBuilder)).download(this.pathSupplier);
    }

    @Test
    public void testDownload() {
        String expectedDownloadURL = "defaulteditor/download?path=default%3A%2F%2Fmain%40MySpace%2FMortgages%2Fsrc%2Fmain%2Fresources%2Frule.drl";
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)"default://main@MySpace/Mortgages/src/main/resources/rule.drl");
        ((DownloadMenuItemBuilder)Mockito.doNothing().when((Object)this.downloadMenuItemBuilder)).open((String)ArgumentMatchers.any());
        this.downloadMenuItemBuilder.download(this.pathSupplier);
        ((DownloadMenuItemBuilder)Mockito.verify((Object)this.downloadMenuItemBuilder)).open((String)ArgumentMatchers.eq((Object)"defaulteditor/download?path=default%3A%2F%2Fmain%40MySpace%2FMortgages%2Fsrc%2Fmain%2Fresources%2Frule.drl"));
    }

    @Test
    public void testDownloadSpaceAndAmpersand() {
        String expectedDownloadURL = "defaulteditor/download?path=default%3A%2F%2Fmain%40MySpace%2FMortgages%2Fsrc%2Fmain%2Fresources%2Fa+%26+b.drl";
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)"default://main@MySpace/Mortgages/src/main/resources/a & b.drl");
        ((DownloadMenuItemBuilder)Mockito.doNothing().when((Object)this.downloadMenuItemBuilder)).open((String)ArgumentMatchers.any());
        this.downloadMenuItemBuilder.download(this.pathSupplier);
        ((DownloadMenuItemBuilder)Mockito.verify((Object)this.downloadMenuItemBuilder)).open((String)ArgumentMatchers.eq((Object)"defaulteditor/download?path=default%3A%2F%2Fmain%40MySpace%2FMortgages%2Fsrc%2Fmain%2Fresources%2Fa+%26+b.drl"));
    }
}

