/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.exports;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.function.BiConsumer;
import org.jboss.errai.common.client.dom.Blob;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.editor.commons.client.file.exports.AbstractFileExportTest;
import org.uberfire.ext.editor.commons.client.file.exports.ImageDataUriContent;
import org.uberfire.ext.editor.commons.client.file.exports.ImageFileExport;

@RunWith(value=GwtMockitoTestRunner.class)
public class ImageFileExportTest
extends AbstractFileExportTest {
    private ImageFileExport tested;

    @Before
    public void setup() {
        this.tested = new ImageFileExport(this.fileSaver);
    }

    @Test
    public void testExport() {
        ImageDataUriContent imageContent = ImageDataUriContent.create((String)"data:image/jpeg;base64,9j/4AAQSkZJRgABAQEASABIAAD");
        Assert.assertEquals((Object)"data:image/jpeg;base64,9j/4AAQSkZJRgABAQEASABIAAD", (Object)imageContent.getUri());
        Assert.assertEquals((Object)"image/jpeg", (Object)imageContent.getMimeType());
        Assert.assertEquals((Object)"9j/4AAQSkZJRgABAQEASABIAAD", (Object)imageContent.getData());
        this.tested.export((Object)imageContent, "file1");
        ((BiConsumer)Mockito.verify((Object)this.fileSaver, (VerificationMode)Mockito.times((int)1))).accept((Blob)Mockito.any(Blob.class), (String)ArgumentMatchers.eq((Object)"file1"));
    }
}

