/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.exports.jso;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.editor.commons.client.file.exports.FileExportResources;
import org.uberfire.ext.editor.commons.client.file.exports.jso.FileExportScriptInjector;
import org.uberfire.ext.editor.commons.client.file.exports.jso.JsFileSaver;
import org.uberfire.ext.editor.commons.client.file.exports.jso.JsPdf;

@RunWith(value=GwtMockitoTestRunner.class)
public class FileExportScriptInjectorTest {
    public static final String NS = "window.";
    private FileExportScriptInjector tested;
    @Mock
    private Consumer<String> scriptInjector;

    @Before
    public void setup() {
        this.tested = new FileExportScriptInjector(this.scriptInjector);
    }

    @Test
    public void testInject() {
        this.tested.inject();
        ArgumentCaptor scriptCaptor = ArgumentCaptor.forClass(String.class);
        ((Consumer)Mockito.verify(this.scriptInjector, (VerificationMode)Mockito.times((int)1))).accept((String)scriptCaptor.capture());
        String script = (String)scriptCaptor.getValue();
        String fsNsObject = FileExportScriptInjector.buildNamespaceObject((String)(NS + JsFileSaver.class.getSimpleName() + ".saveAs"));
        String jsPdfNsObject = FileExportScriptInjector.buildNamespaceObject((String)(NS + JsPdf.class.getSimpleName()));
        String c2sNsObject = FileExportResources.INSTANCE.canvas2svg().getText();
        Assert.assertEquals((Object)("var " + fsNsObject + " = function(blob, fileName, disableAutoBOM) {\nfileSaver\nreturn saveAs(blob, fileName, disableAutoBOM);};\n" + jsPdfNsObject + " = function(settings) {\njsPdf\nvar saveAs = " + NS + "JsFileSaver.saveAs; return new jsPDF(settings);};\n" + c2sNsObject + "\n"), (Object)script);
    }

    @Test
    public void testNamespaces() {
        Assert.assertEquals((Object)"window = window || {};\nwindow.JsFileSaver", (Object)FileExportScriptInjector.buildNamespaceObject((String)(NS + JsFileSaver.class.getSimpleName())));
        Assert.assertEquals((Object)"window = window || {};\nwindow.JsPdf", (Object)FileExportScriptInjector.buildNamespaceObject((String)(NS + JsPdf.class.getSimpleName())));
        Assert.assertEquals((Object)"nonamespace", (Object)FileExportScriptInjector.buildNamespaceObject((String)"nonamespace"));
    }
}

