/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.menu.common;

import java.util.function.Supplier;
import javax.enterprise.event.Event;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.RenameInProgressEvent;
import org.uberfire.ext.editor.commons.client.file.CommandWithFileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.FileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.popups.RenamePopUpPresenter;
import org.uberfire.ext.editor.commons.client.menu.common.SaveAndRenameCommandBuilder;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.file.DefaultMetadata;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class SaveAndRenameCommandBuilderTest {
    @Mock
    public SupportsSaveAndRename<String, DefaultMetadata> service;
    @Mock
    private RenamePopUpPresenter renamePopUpPresenter;
    @Mock
    private RenamePopUpPresenter.View renamePopUpPresenterView;
    @Mock
    private BusyIndicatorView busyIndicatorView;
    @Mock
    private Event<NotificationEvent> notification;
    @Mock
    private Path path;
    @Mock
    private DefaultMetadata metadata;
    @Mock
    private Validator validator;
    @Mock
    private ParameterizedCommand<Path> onSuccess;
    @Mock
    private Command onError;
    @Mock
    private NotificationEvent notificationEvent;
    @Mock
    private EventSourceMock<RenameInProgressEvent> renameInProgressEvent;
    @Mock
    private Command beforeSaveAndRenameCommand;
    private SaveAndRenameCommandBuilder<String, DefaultMetadata> builder;
    private Caller<SupportsSaveAndRename<String, DefaultMetadata>> renameCaller;
    private boolean isDirty = true;
    private String content = "content";
    private Supplier<Path> pathSupplierFake = () -> this.path;
    private Supplier<DefaultMetadata> metadataSupplierFake = () -> this.metadata;
    private Supplier<String> contentSupplierFake = () -> this.content;
    private Supplier<Boolean> isDirtySupplierFake = () -> this.isDirty;

    @Before
    public void setup() {
        this.builder = (SaveAndRenameCommandBuilder)Mockito.spy((Object)new SaveAndRenameCommandBuilder(this.renamePopUpPresenter, this.busyIndicatorView, this.notification, this.renameInProgressEvent));
        this.renameCaller = (Caller)Mockito.spy((Object)new CallerMock(this.service));
        ((RenamePopUpPresenter)Mockito.doReturn((Object)this.renamePopUpPresenterView).when((Object)this.renamePopUpPresenter)).getView();
        ((SaveAndRenameCommandBuilder)Mockito.doReturn((Object)this.notificationEvent).when(this.builder)).makeItemRenamedSuccessfullyEvent();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBuildWhenPathSupplierIsNull() throws Exception {
        this.builder.addValidator(this.validator).addRenameService(this.renameCaller).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBuildWhenValidatorIsNull() throws Exception {
        this.builder.addPathSupplier(this.pathSupplierFake).addRenameService(this.renameCaller).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBuildWhenRenameCallerIsNull() throws Exception {
        this.builder.addPathSupplier(this.pathSupplierFake).addValidator(this.validator).build();
    }

    @Test
    public void testBuildWhenRequiredParametersArePresent() throws Exception {
        CommandWithFileNameAndCommitMessage renameCommand = (CommandWithFileNameAndCommitMessage)Mockito.mock(CommandWithFileNameAndCommitMessage.class);
        CommandWithFileNameAndCommitMessage saveAndRenameCommand = (CommandWithFileNameAndCommitMessage)Mockito.mock(CommandWithFileNameAndCommitMessage.class);
        ((SaveAndRenameCommandBuilder)Mockito.doReturn((Object)renameCommand).when(this.builder)).makeRenameCommand();
        ((SaveAndRenameCommandBuilder)Mockito.doReturn((Object)saveAndRenameCommand).when(this.builder)).makeSaveAndRenameCommand();
        Command command = this.builder.addPathSupplier(this.pathSupplierFake).addValidator(this.validator).addRenameService(this.renameCaller).addMetadataSupplier(this.metadataSupplierFake).addContentSupplier(this.contentSupplierFake).addIsDirtySupplier(this.isDirtySupplierFake).build();
        command.execute();
        ((RenamePopUpPresenter)Mockito.verify((Object)this.renamePopUpPresenter)).show(this.path, this.validator, this.isDirty, renameCommand, saveAndRenameCommand);
    }

    @Test
    public void testMakeSaveAndRenameCommand() throws Exception {
        String newFileName = "newFileName";
        String commitMessage = "commitMessage";
        FileNameAndCommitMessage message = new FileNameAndCommitMessage("newFileName", "commitMessage");
        ((SaveAndRenameCommandBuilder)Mockito.doNothing().when(this.builder)).showBusyIndicator();
        this.builder.addRenameService(this.renameCaller).addPathSupplier(this.pathSupplierFake).makeSaveAndRenameCommand().execute((Object)message);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.builder});
        ((SaveAndRenameCommandBuilder)inOrder.verify(this.builder)).showBusyIndicator();
        ((SaveAndRenameCommandBuilder)inOrder.verify(this.builder)).callSaveAndRename(message);
        ((SaveAndRenameCommandBuilder)inOrder.verify(this.builder)).hideRenamePopup();
        ((SaveAndRenameCommandBuilder)inOrder.verify(this.builder)).hideBusyIndicator();
        ((SaveAndRenameCommandBuilder)inOrder.verify(this.builder)).notifyItemRenamedSuccessfully();
    }

    @Test
    public void testMakeRenameCommand() throws Exception {
        String newFileName = "newFileName";
        String commitMessage = "commitMessage";
        FileNameAndCommitMessage message = new FileNameAndCommitMessage("newFileName", "commitMessage");
        ((SaveAndRenameCommandBuilder)Mockito.doNothing().when(this.builder)).showBusyIndicator();
        ((SupportsSaveAndRename)Mockito.doReturn((Object)this.path).when(this.service)).rename(this.path, "newFileName", "commitMessage");
        this.builder.addRenameService(this.renameCaller).addPathSupplier(this.pathSupplierFake).makeRenameCommand().execute((Object)message);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.builder});
        ((SaveAndRenameCommandBuilder)inOrder.verify(this.builder)).showBusyIndicator();
        ((SaveAndRenameCommandBuilder)inOrder.verify(this.builder)).callRename(message);
        ((SaveAndRenameCommandBuilder)inOrder.verify(this.builder)).hideRenamePopup();
        ((SaveAndRenameCommandBuilder)inOrder.verify(this.builder)).hideBusyIndicator();
        ((SaveAndRenameCommandBuilder)inOrder.verify(this.builder)).notifyItemRenamedSuccessfully();
    }

    @Test
    public void callSaveAndRename() {
        String newFileName = "newFileName";
        String commitMessage = "commitMessage";
        FileNameAndCommitMessage message = new FileNameAndCommitMessage("newFileName", "commitMessage");
        this.builder.addRenameService(this.renameCaller).addPathSupplier(this.pathSupplierFake).addMetadataSupplier(this.metadataSupplierFake).addContentSupplier(this.contentSupplierFake).addSuccessCallback(this.onSuccess).addBeforeSaveAndRenameCommand(this.beforeSaveAndRenameCommand).callSaveAndRename(message);
        ((Command)Mockito.verify((Object)this.beforeSaveAndRenameCommand, (VerificationMode)Mockito.only())).execute();
        ((Caller)Mockito.verify(this.renameCaller, (VerificationMode)Mockito.only())).call((RemoteCallback)ArgumentMatchers.isA(RemoteCallback.class), (ErrorCallback)ArgumentMatchers.isA(SaveAndRenameCommandBuilder.SaveAndRenameErrorCallback.class));
        ((SupportsSaveAndRename)Mockito.verify(this.service, (VerificationMode)Mockito.only())).saveAndRename((Path)ArgumentMatchers.eq((Object)this.path), (String)ArgumentMatchers.eq((Object)"newFileName"), (Object)((DefaultMetadata)ArgumentMatchers.eq((Object)this.metadata)), (Object)((String)ArgumentMatchers.eq((Object)this.content)), (String)ArgumentMatchers.eq((Object)"commitMessage"));
    }

    @Test
    public void testOnSuccess() throws Exception {
        RenameInProgressEvent renameInProgressEvent = (RenameInProgressEvent)Mockito.mock(RenameInProgressEvent.class);
        ((SaveAndRenameCommandBuilder)Mockito.doReturn((Object)renameInProgressEvent).when(this.builder)).makeRenameInProgressEvent();
        this.builder.addSuccessCallback(this.onSuccess).onSuccess().callback((Object)this.path);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.onSuccess, this.builder});
        ((SaveAndRenameCommandBuilder)inOrder.verify(this.builder)).notifyRenameInProgress();
        ((ParameterizedCommand)inOrder.verify(this.onSuccess)).execute((Object)this.path);
        ((SaveAndRenameCommandBuilder)inOrder.verify(this.builder)).hideRenamePopup();
        ((SaveAndRenameCommandBuilder)inOrder.verify(this.builder)).hideBusyIndicator();
        ((SaveAndRenameCommandBuilder)inOrder.verify(this.builder)).notifyItemRenamedSuccessfully();
    }

    @Test
    public void testNotifyRenameInProgress() {
        RenameInProgressEvent event = (RenameInProgressEvent)Mockito.mock(RenameInProgressEvent.class);
        ((SaveAndRenameCommandBuilder)Mockito.doReturn((Object)event).when(this.builder)).makeRenameInProgressEvent();
        this.builder.notifyRenameInProgress();
        ((EventSourceMock)Mockito.verify(this.renameInProgressEvent)).fire((Object)event);
    }

    @Test
    public void testMakeRenameInProgressEvent() {
        Path path = (Path)Mockito.mock(Path.class);
        ((SaveAndRenameCommandBuilder)Mockito.doReturn((Object)path).when(this.builder)).getPath();
        RenameInProgressEvent event = this.builder.makeRenameInProgressEvent();
        Assert.assertEquals((Object)path, (Object)event.getPath());
    }

    @Test
    public void testOnErrorWhenFileAlreadyExists() throws Exception {
        Message message = (Message)Mockito.mock(Message.class);
        Throwable throwable = (Throwable)Mockito.mock(Throwable.class);
        ((Throwable)Mockito.doReturn((Object)"FileAlreadyExistsException").when((Object)throwable)).getMessage();
        boolean error = this.builder.addErrorCallback(this.onError).onError().error(message, throwable);
        ((BusyIndicatorView)Mockito.verify((Object)this.busyIndicatorView)).hideBusyIndicator();
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder)).handleDuplicatedFileName();
        ((Command)Mockito.verify((Object)this.onError, (VerificationMode)Mockito.never())).execute();
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder, (VerificationMode)Mockito.never())).hideRenamePopup();
        Assert.assertFalse((boolean)error);
    }

    @Test
    public void testOnErrorWhenFileDoesNotExist() throws Exception {
        Message message = (Message)Mockito.mock(Message.class);
        Throwable throwable = (Throwable)Mockito.mock(Throwable.class);
        SaveAndRenameCommandBuilder.SaveAndRenameErrorCallback onSaveAndRenameError = this.builder.addErrorCallback(this.onError).onError();
        SaveAndRenameCommandBuilder.SaveAndRenameErrorCallback onErrorSpy = (SaveAndRenameCommandBuilder.SaveAndRenameErrorCallback)Mockito.spy((Object)onSaveAndRenameError);
        ((Throwable)Mockito.doReturn((Object)"").when((Object)throwable)).getMessage();
        ((SaveAndRenameCommandBuilder.SaveAndRenameErrorCallback)Mockito.doReturn((Object)true).when((Object)onErrorSpy)).callSuper(message, throwable);
        boolean error = onErrorSpy.error(message, throwable);
        ((Command)Mockito.verify((Object)this.onError)).execute();
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder)).hideRenamePopup();
        ((BusyIndicatorView)Mockito.verify((Object)this.busyIndicatorView, (VerificationMode)Mockito.never())).hideBusyIndicator();
        ((SaveAndRenameCommandBuilder)Mockito.verify(this.builder, (VerificationMode)Mockito.never())).handleDuplicatedFileName();
        Assert.assertTrue((boolean)error);
    }
}

