/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.commons.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.async.DescriptiveThreadFactory;
import org.uberfire.commons.concurrent.Managed;
import org.uberfire.commons.concurrent.Unmanaged;

public class ExecutorServiceProducer {
    private Logger logger = LoggerFactory.getLogger(ExecutorServiceProducer.class);
    private final ExecutorService executorService = this.buildFixedThreadPoolExecutorService("org.appformer.concurrent.managed.thread.limit");
    private final ExecutorService unmanagedExecutorService = this.buildFixedThreadPoolExecutorService("org.appformer.concurrent.unmanaged.thread.limit");
    protected static final String MANAGED_LIMIT_PROPERTY = "org.appformer.concurrent.managed.thread.limit";
    protected static final String UNMANAGED_LIMIT_PROPERTY = "org.appformer.concurrent.unmanaged.thread.limit";

    protected ExecutorService buildFixedThreadPoolExecutorService(String key) {
        int threadLimit;
        String stringProperty = System.getProperty(key);
        int n = threadLimit = stringProperty == null ? 0 : this.toInteger(stringProperty);
        if (threadLimit > 0) {
            return Executors.newFixedThreadPool(threadLimit, new DescriptiveThreadFactory());
        }
        return Executors.newCachedThreadPool(new DescriptiveThreadFactory());
    }

    private Integer toInteger(String stringProperty) {
        try {
            return Integer.valueOf(stringProperty);
        }
        catch (NumberFormatException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Property {} is invalid, defaulting to 0", (Object)stringProperty);
            }
            return 0;
        }
    }

    @Produces
    @ApplicationScoped
    @Managed
    public ExecutorService produceExecutorService() {
        return this.getManagedExecutorService();
    }

    @Produces
    @ApplicationScoped
    @Unmanaged
    public ExecutorService produceUnmanagedExecutorService() {
        return this.getUnmanagedExecutorService();
    }

    protected ExecutorService getManagedExecutorService() {
        return this.executorService;
    }

    protected ExecutorService getUnmanagedExecutorService() {
        return this.unmanagedExecutorService;
    }
}

