/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.commons.cluster;

import java.util.function.Consumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.commons.cluster.ClusterJMSService;
import org.uberfire.commons.cluster.ClusterService;

@RunWith(value=MockitoJUnitRunner.class)
public class ClusterJMSServiceTest {
    @Spy
    private ClusterJMSService clusterService = new ClusterJMSService();
    @Mock
    private Session session;
    @Mock
    private Destination destination;
    @Mock
    private MessageConsumer consumer;

    @Before
    public void setUp() throws JMSException {
        ((ClusterJMSService)Mockito.doReturn((Object)this.session).when((Object)this.clusterService)).createConsumerSession();
        ((ClusterJMSService)Mockito.doReturn((Object)this.destination).when((Object)this.clusterService)).createDestination((ClusterService.DestinationType)Matchers.any(), (String)Matchers.any(), (Session)Matchers.any());
        ((Session)Mockito.doReturn((Object)this.consumer).when((Object)this.session)).createConsumer((Destination)Matchers.any());
    }

    @Test(expected=RuntimeException.class)
    public void noConnectionModeShouldThrowException() {
        this.clusterService.connect();
    }

    @Test
    public void testSessionAlreadyCreated() throws Exception {
        String channelName = "channel";
        Consumer<Object> consumer = o -> {};
        this.clusterService.createConsumer(ClusterService.DestinationType.PubSub, channelName, Object.class, consumer);
        this.clusterService.createConsumer(ClusterService.DestinationType.PubSub, channelName, Object.class, consumer);
        ((ClusterJMSService)Mockito.verify((Object)this.clusterService, (VerificationMode)Mockito.times((int)1))).createConsumerSession();
        ((ClusterJMSService)Mockito.verify((Object)this.clusterService, (VerificationMode)Mockito.times((int)1))).createDestination((ClusterService.DestinationType)Matchers.eq((Object)ClusterService.DestinationType.PubSub), (String)Matchers.eq((Object)channelName), (Session)Matchers.eq((Object)this.session));
    }

    @Test
    public void testDoNotSaveSession() throws Exception {
        ((Session)Mockito.doReturn(null).when((Object)this.session)).createConsumer((Destination)Matchers.any());
        String channelName = "channel";
        Consumer<Object> consumer = o -> {};
        this.clusterService.createConsumer(ClusterService.DestinationType.PubSub, channelName, Object.class, consumer);
        this.clusterService.createConsumer(ClusterService.DestinationType.PubSub, channelName, Object.class, consumer);
        ((ClusterJMSService)Mockito.verify((Object)this.clusterService, (VerificationMode)Mockito.times((int)2))).createConsumerSession();
        ((ClusterJMSService)Mockito.verify((Object)this.clusterService, (VerificationMode)Mockito.times((int)2))).createDestination((ClusterService.DestinationType)Matchers.eq((Object)ClusterService.DestinationType.PubSub), (String)Matchers.eq((Object)channelName), (Session)Matchers.eq((Object)this.session));
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)2))).close();
    }
}

