/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.commons.cluster;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Session;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.uberfire.commons.cluster.ClusterService;

public abstract class BaseClusterJMSServiceTest {
    ClusterService clusterService;
    static ConnectionFactory factory;
    Connection connection;
    Session session1;
    Session session2;

    @Before
    public void setup() throws JMSException {
        factory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
        this.connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)factory.createConnection((String)Mockito.any(), (String)Mockito.any())).thenReturn((Object)this.connection);
        Mockito.when((Object)factory.createConnection()).thenReturn((Object)this.connection);
        this.session1 = (Session)Mockito.mock(Session.class);
        this.session2 = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)this.connection.createSession(Matchers.eq((boolean)false), Matchers.eq((int)1))).thenReturn((Object)this.session1, (Object[])new Session[]{this.session2});
        this.clusterService = this.getClusterService(factory);
    }

    abstract ClusterService getClusterService(ConnectionFactory var1);

    @After
    public void tearDown() {
        System.clearProperty("appformer-jms-connection-mode");
        System.clearProperty("appformer-jms-url");
        System.clearProperty("appformer-initial-context-factory");
        System.clearProperty("appformer-jms-connection-factory");
        System.clearProperty("appformer-jms-username");
        System.clearProperty("appformer-jms-password");
    }

    @Test
    public void connectTestEmptyUserNameAndPassword() throws JMSException {
        this.clusterService.connect();
        ((Connection)Mockito.verify((Object)this.connection)).setExceptionListener((ExceptionListener)Mockito.any());
        ((Connection)Mockito.verify((Object)this.connection)).start();
        ((ConnectionFactory)Mockito.verify((Object)factory)).createConnection();
    }

    @Test
    public void connectTest() throws JMSException {
        System.setProperty("appformer-jms-username", "dora");
        System.setProperty("appformer-jms-password", "bento");
        this.clusterService = this.getClusterService(factory);
        this.clusterService.connect();
        ((Connection)Mockito.verify((Object)this.connection)).setExceptionListener((ExceptionListener)Mockito.any());
        ((Connection)Mockito.verify((Object)this.connection)).start();
        ((ConnectionFactory)Mockito.verify((Object)factory)).createConnection((String)Mockito.any(), (String)Mockito.any());
    }

    @Test
    public void sessionConsumersCreatedShouldBeClosed() throws JMSException {
        this.clusterService.connect();
        this.clusterService.createConsumer(ClusterService.DestinationType.PubSub, "dora_destination", Object.class, l -> {});
        this.clusterService.createConsumer(ClusterService.DestinationType.PubSub, "dora_destination", Object.class, l -> {});
        this.clusterService.close();
        ((Session)Mockito.verify((Object)this.session1)).close();
        ((Session)Mockito.verify((Object)this.session2)).close();
        ((Connection)Mockito.verify((Object)this.connection)).close();
    }
}

