/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.commons.uuid;

import org.junit.Assert;
import org.junit.Test;
import org.uberfire.commons.uuid.UUID;

public class UUIDTest {
    @Test
    public void hasFiveGroups() throws Exception {
        String uuid = UUID.uuid();
        String[] split = uuid.split("-");
        Assert.assertEquals((long)5L, (long)split.length);
    }

    @Test
    public void generateWithGivenLength() throws Exception {
        Assert.assertEquals((long)12L, (long)UUID.uuid((int)12).length());
        Assert.assertEquals((long)6L, (long)UUID.uuid((int)6).length());
        Assert.assertEquals((long)100L, (long)UUID.uuid((int)100).length());
    }

    @Test(expected=IllegalArgumentException.class)
    public void tooLongRadix() throws Exception {
        UUID.uuid((int)10, (int)63);
    }

    @Test
    public void generateWithGivenLengthAndRadix() throws Exception {
        this.assertOnlyContainsCharacters(UUID.uuid((int)10, (int)2), "0", "1");
    }

    private void assertOnlyContainsCharacters(String uuid, String ... chars) {
        String tmp = uuid;
        for (String aChar : chars) {
            tmp = tmp.replaceAll(aChar, "");
        }
        Assert.assertTrue((String)("Found illegal characters: " + tmp), (boolean)tmp.isEmpty());
    }
}

