/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.commons.concurrent;

import java.util.concurrent.ThreadPoolExecutor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.commons.concurrent.ExecutorServiceProducer;

public class ExecutorServiceProducerTest {
    @Before
    public void setUp() {
        System.clearProperty("org.appformer.concurrent.managed.thread.limit");
    }

    @Test
    public void testSystemPropertySet() {
        System.setProperty("org.appformer.concurrent.managed.thread.limit", "1000");
        ExecutorServiceProducer producer = new ExecutorServiceProducer();
        ThreadPoolExecutor executor = (ThreadPoolExecutor)producer.buildFixedThreadPoolExecutorService("org.appformer.concurrent.managed.thread.limit");
        Assert.assertEquals((long)1000L, (long)executor.getMaximumPoolSize());
    }

    @Test
    public void testSystemPropertyNotSet() {
        System.clearProperty("org.appformer.concurrent.managed.thread.limit");
        ExecutorServiceProducer producer = new ExecutorServiceProducer();
        ThreadPoolExecutor executor = (ThreadPoolExecutor)producer.buildFixedThreadPoolExecutorService("org.appformer.concurrent.managed.thread.limit");
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)executor.getMaximumPoolSize());
    }
}

