/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.service.storage.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefinition;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;
import org.uberfire.experimental.service.storage.ExperimentalFeaturesStorage;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.SpacesAPI;

public abstract class AbstractExperimentalFeaturesStorage
implements ExperimentalFeaturesStorage {
    public static final String COMMENTS = "Updating experimental features registry";
    private static final String EXPERIMENTAL = "experimental";
    public static final String EXPERIMENTAL_FILE_NAME = ".experimental";
    public static final String SEPARATOR = "/";
    public static final String EXPERIMENTAL_STORAGE_FOLDER = "/experimental";
    protected final SessionInfo sessionInfo;
    protected final SpacesAPI spaces;
    protected final IOService ioService;
    protected final ExperimentalFeatureDefRegistry defRegistry;
    protected FileSystem fileSystem;

    public AbstractExperimentalFeaturesStorage(SessionInfo sessionInfo, SpacesAPI spaces, IOService ioService, ExperimentalFeatureDefRegistry defRegistry) {
        this.sessionInfo = sessionInfo;
        this.spaces = spaces;
        this.ioService = ioService;
        this.defRegistry = defRegistry;
    }

    public abstract String getStoragePath();

    protected abstract Collection<ExperimentalFeatureDefinition> getSupportedDefinitions();

    protected abstract Logger log();

    protected List<ExperimentalFeatureImpl> readFeatures() {
        Path fsPath = this.fileSystem.getPath(this.getStoragePath(), new String[0]);
        ArrayList<ExperimentalFeatureImpl> registeredFeatures = new ArrayList<ExperimentalFeatureImpl>();
        boolean existsOnVFS = true;
        if (this.ioService.exists(fsPath)) {
            try (InputStream in = this.ioService.newInputStream(fsPath, new OpenOption[0]);){
                Properties properties = new Properties();
                properties.load(in);
                properties.entrySet().stream().map(entry -> new ExperimentalFeatureImpl((String)entry.getKey(), Boolean.valueOf((String)entry.getValue()).booleanValue())).forEach(registeredFeatures::add);
            }
            catch (Exception ex) {
                this.log().warn("Impossible to load registry", (Throwable)ex);
            }
        } else {
            existsOnVFS = false;
        }
        boolean requiresVFSSync = this.syncLoadedFeatures(registeredFeatures);
        if (!existsOnVFS || requiresVFSSync) {
            this.storeFeatures(registeredFeatures);
        }
        return registeredFeatures;
    }

    private boolean syncLoadedFeatures(List<ExperimentalFeatureImpl> registeredFeatures) {
        List extraFeatures;
        Collection<ExperimentalFeatureDefinition> expectedDefinitions = this.getSupportedDefinitions();
        List registryFeatureIds = registeredFeatures.stream().map(ExperimentalFeatureImpl::getFeatureId).collect(Collectors.toList());
        List expectedFeatureIds = expectedDefinitions.stream().map(ExperimentalFeatureDefinition::getId).collect(Collectors.toList());
        List missingFeatures = expectedFeatureIds.stream().filter(expectedFeatureId -> !registryFeatureIds.contains(expectedFeatureId)).collect(Collectors.toList());
        boolean requiresSync = false;
        if (!missingFeatures.isEmpty()) {
            requiresSync = true;
            missingFeatures.stream().forEach(expectedFeatureId -> registeredFeatures.add(new ExperimentalFeatureImpl(expectedFeatureId, false)));
        }
        if (!(extraFeatures = registryFeatureIds.stream().filter(registeredFeatureId -> !expectedFeatureIds.contains(registeredFeatureId)).map(registryFeatureId -> registeredFeatures.stream().filter(experimentalFeature -> experimentalFeature.getFeatureId().equals(registryFeatureId)).findAny().orElse(null)).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            requiresSync = true;
            registeredFeatures.removeAll(extraFeatures);
        }
        return requiresSync;
    }

    @Override
    public void storeFeatures(Collection<ExperimentalFeatureImpl> features) {
        this.doStoreFeatures(features, () -> {});
    }

    @Override
    public void store(ExperimentalFeatureImpl feature) {
        List registeredFeatures = (List)this.getFeatures();
        Optional<ExperimentalFeatureImpl> optional = registeredFeatures.stream().filter(registeredFeature -> registeredFeature.getFeatureId().equals(feature.getFeatureId())).findAny();
        if (optional.isPresent()) {
            ExperimentalFeatureImpl registeredFeature2 = optional.get();
            registeredFeature2.setEnabled(feature.isEnabled());
            this.doStoreFeatures(registeredFeatures, () -> this.maybeNotifyFeatureUpdate(feature));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStoreFeatures(Collection<ExperimentalFeatureImpl> features, Runnable callback) {
        String path = this.getStoragePath();
        Path fsPath = this.fileSystem.getPath(path, new String[0]);
        Properties properties = new Properties();
        features.stream().filter(experimentalFeature -> this.defRegistry.getFeatureById(experimentalFeature.getFeatureId()) != null).forEach(feature -> properties.put(feature.getFeatureId(), String.valueOf(feature.isEnabled())));
        try (OutputStream out = this.ioService.newOutputStream(fsPath, new OpenOption[0]);){
            this.ioService.startBatch(this.fileSystem);
            properties.store(out, COMMENTS);
            if (callback != null) {
                callback.run();
            }
        }
        catch (Exception ex) {
            this.log().warn("Impossible to write experimental features registry on '{}': {}", (Object)path, (Object)ex);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    protected void initializeFileSystem() {
        URI fileSystemURI = this.spaces.resolveFileSystemURI(SpacesAPI.Scheme.GIT, SpacesAPI.DEFAULT_SPACE, "preferences");
        try {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("init", Boolean.TRUE);
            options.put("internal", Boolean.TRUE);
            this.fileSystem = this.ioService.newFileSystem(fileSystemURI, options);
        }
        catch (FileSystemAlreadyExistsException e) {
            this.fileSystem = this.ioService.getFileSystem(fileSystemURI);
        }
    }

    protected void maybeNotifyFeatureUpdate(ExperimentalFeatureImpl feature) {
    }
}

