/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.jboss.errai.marshalling.server.MappingContextSingleton;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.experimental.service.BackendExperimentalFeaturesRegistryServiceImpl;
import org.uberfire.experimental.service.backend.ExperimentalFeaturesSession;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefinition;
import org.uberfire.experimental.service.definition.impl.ExperimentalFeatureDefRegistryImpl;
import org.uberfire.experimental.service.editor.EditableExperimentalFeature;
import org.uberfire.experimental.service.events.PortableExperimentalFeatureModifiedEvent;
import org.uberfire.experimental.service.registry.ExperimentalFeaturesRegistry;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;
import org.uberfire.experimental.service.storage.ExperimentalFeaturesStorage;
import org.uberfire.experimental.service.storage.impl.GlobalExperimentalFeaturesStorageImpl;
import org.uberfire.experimental.service.storage.impl.UserExperimentalFeaturesStorageImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mocks.FileSystemTestingUtils;
import org.uberfire.mocks.SessionInfoMock;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class BackendExperimentalFeaturesRegistryServiceImplTest {
    protected static final String GLOBAL_FEATURE_1 = "globalFeature_1";
    protected static final String GLOBAL_FEATURE_2 = "globalFeature_2";
    protected static final String GLOBAL_FEATURE_3 = "globalFeature_3";
    protected static final String FEATURE_1 = "feature_1";
    protected static final String FEATURE_2 = "feature_2";
    protected static final String FEATURE_3 = "feature_3";
    protected static final String UNEXISTING_FEATURE = "unexisting featureID";
    protected static final String USER_NAME = "my-user";
    protected static FileSystemTestingUtils fileSystemTestingUtils = new FileSystemTestingUtils();
    protected SessionInfo sessionInfo;
    @Mock
    protected SpacesAPI spaces;
    @Mock
    protected IOService ioService;
    @Mock
    protected ExperimentalFeatureDefRegistryImpl defRegistry;
    protected FileSystem fileSystem;
    @Mock
    private EventSourceMock<PortableExperimentalFeatureModifiedEvent> event;
    private GlobalExperimentalFeaturesStorageImpl globalStorage;
    private UserExperimentalFeaturesStorageImpl userStorage;
    private BackendExperimentalFeaturesRegistryServiceImpl service;

    @Before
    public void init() throws IOException {
        MappingContextSingleton.get();
        fileSystemTestingUtils.setup();
        this.sessionInfo = new SessionInfoMock(USER_NAME);
        this.fileSystem = fileSystemTestingUtils.getFileSystem();
        this.ioService = (IOService)Mockito.spy((Object)fileSystemTestingUtils.getIoService());
        ((IOService)Mockito.doNothing().when((Object)this.ioService)).startBatch((FileSystem)Matchers.any(FileSystem.class));
        ((IOService)Mockito.doNothing().when((Object)this.ioService)).endBatch();
        ((IOService)Mockito.doReturn((Object)this.fileSystem).when((Object)this.ioService)).newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap());
        this.defRegistry = new ExperimentalFeatureDefRegistryImpl();
        this.defRegistry.register(new ExperimentalFeatureDefinition(GLOBAL_FEATURE_1, true, "", GLOBAL_FEATURE_1, GLOBAL_FEATURE_1));
        this.defRegistry.register(new ExperimentalFeatureDefinition(GLOBAL_FEATURE_2, true, "", GLOBAL_FEATURE_2, GLOBAL_FEATURE_2));
        this.defRegistry.register(new ExperimentalFeatureDefinition(GLOBAL_FEATURE_3, true, "", GLOBAL_FEATURE_3, GLOBAL_FEATURE_3));
        this.defRegistry.register(new ExperimentalFeatureDefinition(FEATURE_1, false, "", FEATURE_1, FEATURE_1));
        this.defRegistry.register(new ExperimentalFeatureDefinition(FEATURE_2, false, "", FEATURE_2, FEATURE_2));
        this.defRegistry.register(new ExperimentalFeatureDefinition(FEATURE_3, false, "", FEATURE_3, FEATURE_3));
        this.globalStorage = (GlobalExperimentalFeaturesStorageImpl)Mockito.spy((Object)new GlobalExperimentalFeaturesStorageImpl(this.sessionInfo, this.spaces, this.ioService, (ExperimentalFeatureDefRegistry)this.defRegistry, this.event));
        this.userStorage = (UserExperimentalFeaturesStorageImpl)Mockito.spy((Object)new UserExperimentalFeaturesStorageImpl(this.sessionInfo, this.spaces, this.ioService, (ExperimentalFeatureDefRegistry)this.defRegistry));
    }

    @Test
    public void testLoadRegistryWithExistingData() {
        this.init(true, true);
        Assert.assertTrue((boolean)this.service.isFeatureEnabled(GLOBAL_FEATURE_1));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled(GLOBAL_FEATURE_2));
        Assert.assertTrue((boolean)this.service.isFeatureEnabled(GLOBAL_FEATURE_3));
        Assert.assertTrue((boolean)this.service.isFeatureEnabled(FEATURE_1));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled(FEATURE_2));
        Assert.assertTrue((boolean)this.service.isFeatureEnabled(FEATURE_3));
        Assert.assertTrue((boolean)this.service.isFeatureEnabled(UNEXISTING_FEATURE));
    }

    @Test
    public void testLoadRegistryWithExistingDataExperimentalDisabled() {
        this.init(false, true);
        Assert.assertFalse((boolean)this.service.isFeatureEnabled(GLOBAL_FEATURE_1));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled(GLOBAL_FEATURE_2));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled(GLOBAL_FEATURE_3));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled(FEATURE_1));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled(FEATURE_2));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled(FEATURE_3));
        Assert.assertTrue((boolean)this.service.isFeatureEnabled(UNEXISTING_FEATURE));
    }

    @Test
    public void testLoadRegistryWithoutExistingData() {
        this.init(true, false);
        Assert.assertFalse((boolean)this.service.isFeatureEnabled(GLOBAL_FEATURE_1));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled(GLOBAL_FEATURE_2));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled(GLOBAL_FEATURE_3));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled(FEATURE_1));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled(FEATURE_2));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled(FEATURE_3));
        Assert.assertTrue((boolean)this.service.isFeatureEnabled(UNEXISTING_FEATURE));
    }

    @Test
    public void testLoadRegistryWithoutExistingDataExperimentalDisabled() {
        this.init(false, false);
        Assert.assertFalse((boolean)this.service.isFeatureEnabled(GLOBAL_FEATURE_1));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled(GLOBAL_FEATURE_2));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled(GLOBAL_FEATURE_3));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled(FEATURE_1));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled(FEATURE_2));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled(FEATURE_3));
        Assert.assertTrue((boolean)this.service.isFeatureEnabled(UNEXISTING_FEATURE));
    }

    @Test
    public void testStoreUserLevelFeature() {
        this.testStoreFeature(FEATURE_1, false, (ExperimentalFeaturesStorage)this.userStorage, (ExperimentalFeaturesStorage)this.globalStorage);
    }

    @Test
    public void testStoreGlobalFeature() {
        this.testStoreFeature(GLOBAL_FEATURE_1, false, (ExperimentalFeaturesStorage)this.globalStorage, (ExperimentalFeaturesStorage)this.userStorage);
    }

    @Test
    public void testStoreWrongFeature() {
        this.init(true, true);
        Assertions.assertThatThrownBy(() -> this.service.save(new EditableExperimentalFeature(UNEXISTING_FEATURE, true))).hasMessage("Cannot find ExperimentalFeature 'unexisting featureID'").isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testStoreFeatureExperimentalDisabled() {
        this.init(false, true);
        this.testStoreFeatureExperimentalFeatureDisabled(GLOBAL_FEATURE_1, (ExperimentalFeaturesStorage)this.globalStorage);
        this.testStoreFeatureExperimentalFeatureDisabled(FEATURE_1, (ExperimentalFeaturesStorage)this.userStorage);
        this.testStoreFeatureExperimentalFeatureDisabled(UNEXISTING_FEATURE, (ExperimentalFeaturesStorage)this.globalStorage);
        this.testStoreFeatureExperimentalFeatureDisabled(UNEXISTING_FEATURE, (ExperimentalFeaturesStorage)this.userStorage);
    }

    private void testStoreFeatureExperimentalFeatureDisabled(String featureId, ExperimentalFeaturesStorage storage) {
        Assertions.assertThatThrownBy(() -> this.service.save(new EditableExperimentalFeature(featureId, true))).hasMessage("Impossible edit feature '" + featureId + "': Experimental Framework is disabled").isInstanceOf(IllegalStateException.class);
        ((ExperimentalFeaturesStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.never())).store((ExperimentalFeatureImpl)Matchers.any());
    }

    private void testStoreFeature(String featureId, boolean newValue, ExperimentalFeaturesStorage storage, ExperimentalFeaturesStorage otherStorage) {
        this.init(true, true);
        this.service.save(new EditableExperimentalFeature(featureId, newValue));
        ArgumentCaptor captor = ArgumentCaptor.forClass(ExperimentalFeatureImpl.class);
        ((ExperimentalFeaturesStorage)Mockito.verify((Object)storage)).store((ExperimentalFeatureImpl)captor.capture());
        ((ExperimentalFeaturesStorage)Mockito.verify((Object)otherStorage, (VerificationMode)Mockito.never())).store((ExperimentalFeatureImpl)Matchers.any());
        ExperimentalFeatureImpl feature = (ExperimentalFeatureImpl)captor.getValue();
        ((AbstractObjectAssert)Assertions.assertThat((Object)feature).isNotNull()).hasFieldOrPropertyWithValue("featureId", (Object)featureId).hasFieldOrPropertyWithValue("enabled", (Object)newValue);
    }

    private void init(Boolean enableExperimental, boolean loadData) {
        if (loadData) {
            try {
                Path path = this.fileSystem.getPath(this.globalStorage.getStoragePath(), new String[0]);
                this.ioService.write(path, IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/test/global/regularFeatures.txt"), (Charset)Charset.defaultCharset()), new OpenOption[0]);
                path = this.fileSystem.getPath(this.userStorage.getStoragePath(), new String[0]);
                this.ioService.write(path, IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/test/user/regularFeatures.txt"), (Charset)Charset.defaultCharset()), new OpenOption[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Assert.fail();
            }
        }
        this.globalStorage.init();
        this.userStorage.init();
        System.setProperty("appformer.experimental.features", enableExperimental.toString());
        this.service = new BackendExperimentalFeaturesRegistryServiceImpl((ExperimentalFeatureDefRegistry)this.defRegistry, (ExperimentalFeaturesStorage)this.globalStorage, (ExperimentalFeaturesStorage)this.userStorage);
        ExperimentalFeaturesSession session = this.service.getExperimentalFeaturesSession();
        ((GlobalExperimentalFeaturesStorageImpl)Mockito.verify((Object)this.globalStorage)).getFeatures();
        ((UserExperimentalFeaturesStorageImpl)Mockito.verify((Object)this.userStorage)).getFeatures();
        ((AbstractObjectAssert)Assertions.assertThat((Object)session).isNotNull()).hasFieldOrPropertyWithValue("experimentalFeaturesEnabled", (Object)enableExperimental).hasFieldOrProperty("registry");
        ExperimentalFeaturesRegistry registry = session.getFeaturesRegistry();
        ((IterableAssert)Assertions.assertThat((Iterable)registry.getAllFeatures()).isNotNull()).hasSize(6);
    }

    @After
    public void clean() {
        this.ioService.delete(this.fileSystem.getPath(this.globalStorage.getStoragePath(), new String[0]), new DeleteOption[0]);
        this.ioService.delete(this.fileSystem.getPath(this.userStorage.getStoragePath(), new String[0]), new DeleteOption[0]);
        fileSystemTestingUtils.cleanup();
    }
}

